package com.bxm.adsprod.facade.ticket;

import com.alibaba.fastjson.annotation.JSONField;
import com.bxm.adsprod.facade.tag.Tag;
import com.bxm.adsprod.facade.ticket.inspirevideo.OfferInspireVideo;
import com.bxm.adsprod.facade.ticket.inspirevideo.TicketInspireVideo;
import com.bxm.adsprod.facade.ticket.inspirevideo.TicketInspireVideoCreative;
import com.bxm.warcar.utils.Constants;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;

/**
 * @author allen
 * @since 1.0.0
 */
public class TicketCache implements Serializable {

    private static final long serialVersionUID = 5350115397458848883L;
    private BigInteger id;
    private Integer userGradePassScore;
    private Byte type;
    private String domainCode;
    private List<Tag> tags;
    private List<TicketOnoff> onoffs;
    private List<TicketOs> oss;
    @Deprecated
    private Byte isSupportWechat;
    private List<Integer> apps;
    private Byte status;
    private Integer pauseReason;
    /**
     * CPA 预期价
     */
    private Integer cpaPrice;
    /**
     * 底价
     */
    private Integer floorPrice;
    /**
     * 是否是OCPC广告
     */
    private Integer ocpc;
    /**
     * 屏蔽阈值
     */
    private Integer closeThreshold;
    /**
     * 广告主 ID
     */
    private Long groupId;

    /**
     * 关闭时间,主要用于数据统计
     */
    private Date closeTime;

    /**
     * 独立成本
     */
    private Double standaloneCost;

    @JSONField(serialize = false, deserialize = false)
    private Integer sequence;

    /**
     * 票券扩展信息
     */
    private TicketCouponsInfo ticketCouponsInfo;

    /**
     * 票券素材列表
     */
    private List<TicketAssetsCoupons> ticketAssetsCoupons;

    /**
     * 激励视频信息
     * 老数据有值，被编辑过的券已存储到 {@link TicketAppExtend} 中
     */
    @Deprecated
    private TicketInspireVideo ticketInspireVideo;

    /**
     * 激励视频素材列表
     */
    private List<TicketInspireVideoCreative> ticketInspireVideoCreatives;

    /**
     *  bxmId
     */
    private String bxmId;

    /**
     * 算法名称
     */
    private String algorithmlName;

    /**
     * 投放模式
     */
    private Integer consumeModal;

    /**
     * 外部激励视频广告信息（有道使用）
     */
    private OfferInspireVideo offerInspireVideo;
    /**
     * 本次获取广告券所对应的素材（有道使用）
     */
    private TicketAssets offerAssets;
    private String url;

    private String taobaoClickurl;

    /**
     * 券app相关扩展信息
     */
    private TicketAppExtend adTicketAppExtend;

    @JSONField(serialize = false, deserialize = false)
    public boolean isNormalType() {
        return null != type && type == Ticket.TYPE_NORMAL;
    }
    @JSONField(serialize = false, deserialize = false)
    public boolean isStandbysType() {
        return null != type && type == Ticket.TYPE_STANDBY;
    }
    @JSONField(serialize = false, deserialize = false)
    public boolean isDSP() {
        return null != type && type == Ticket.THIRD_DSP;
    }
    @JSONField(serialize = false, deserialize = false)
    public boolean isRTA() {
        return null != type && type == Ticket.RTA;
    }
    @JSONField(serialize = false, deserialize = false)
    public boolean isSupportedOs(int os) {
        if (CollectionUtils.isEmpty(oss)) {
            return false;
        }
        for (TicketOs ticketOs : oss) {
            if (ticketOs.getSupportOs() == os) {
                return true;
            }
        }
        return false;
    }

    @JSONField(serialize = false, deserialize = false)
    public boolean isCarrier(int a) {
        if (CollectionUtils.isEmpty(apps)) {
            return false;
        }
        for (Integer app : apps) {
            if (app == a) {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    @JSONField(serialize = false, deserialize = false)
    public boolean isSupportedWechat() {
        return null != isSupportWechat && isSupportWechat == Constants.YES;
    }

    @JSONField(serialize = false, deserialize = false)
    public boolean isOcpc() {
        return null != ocpc && ocpc == Constants.YES;
    }

    public String getDomainCode() {
        return domainCode;
    }

    public void setDomainCode(String domainCode) {
        this.domainCode = domainCode;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public BigInteger getId() {
        return id;
    }

    public void setId(BigInteger id) {
        this.id = id;
    }

    public Integer getUserGradePassScore() {
        return userGradePassScore;
    }

    public void setUserGradePassScore(Integer userGradePassScore) {
        this.userGradePassScore = userGradePassScore;
    }

    public List<Tag> getTags() {
        return tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public List<TicketOnoff> getOnoffs() {
        return onoffs;
    }

    public void setOnoffs(List<TicketOnoff> onoffs) {
        this.onoffs = onoffs;
    }

    public List<TicketOs> getOss() {
        return oss;
    }

    public void setOss(List<TicketOs> oss) {
        this.oss = oss;
    }

    public Byte getIsSupportWechat() {
        return isSupportWechat;
    }

    public void setIsSupportWechat(Byte isSupportWechat) {
        this.isSupportWechat = isSupportWechat;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public Integer getPauseReason() {
        return pauseReason;
    }

    public void setPauseReason(Integer pauseReason) {
        this.pauseReason = pauseReason;
    }

    public Integer getSequence() {
        return sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public Integer getCpaPrice() {
        return cpaPrice;
    }

    public void setCpaPrice(Integer cpaPrice) {
        this.cpaPrice = cpaPrice;
    }

    public Integer getFloorPrice() {
        return floorPrice;
    }

    public String getTaobaoClickurl() {
        return taobaoClickurl;
    }

    public void setTaobaoClickurl(String taobaoClickurl) {
        this.taobaoClickurl = taobaoClickurl;
    }

    public void setFloorPrice(Integer floorPrice) {
        this.floorPrice = floorPrice;
    }

    public Integer getOcpc() {
        return ocpc;
    }

    public OfferInspireVideo getOfferInspireVideo() {
        return offerInspireVideo;
    }

    public void setOfferInspireVideo(OfferInspireVideo offerInspireVideo) {
        this.offerInspireVideo = offerInspireVideo;
    }

    public TicketAssets getOfferAssets() {
        return offerAssets;
    }

    public void setOfferAssets(TicketAssets offerAssets) {
        this.offerAssets = offerAssets;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setOcpc(Integer ocpc) {
        this.ocpc = ocpc;
    }

    public Integer getCloseThreshold() {
        return closeThreshold;
    }

    public void setCloseThreshold(Integer closeThreshold) {
        this.closeThreshold = closeThreshold;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public List<Integer> getApps() {
        return apps;
    }

    public void setApps(List<Integer> apps) {
        this.apps = apps;
    }
    public Date getCloseTime() {
        return closeTime;
    }

    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    public Double getStandaloneCost() {
        return null==standaloneCost?0.0:standaloneCost;
    }

    public void setStandaloneCost(Double standaloneCost) {
        this.standaloneCost = standaloneCost;
    }

    public TicketCouponsInfo getTicketCouponsInfo() {
        return ticketCouponsInfo;
    }

    public void setTicketCouponsInfo(TicketCouponsInfo ticketCouponsInfo) {
        this.ticketCouponsInfo = ticketCouponsInfo;
    }

    public List<TicketAssetsCoupons> getTicketAssetsCoupons() {
        return ticketAssetsCoupons;
    }

    public void setTicketAssetsCoupons(List<TicketAssetsCoupons> ticketAssetsCoupons) {
        this.ticketAssetsCoupons = ticketAssetsCoupons;
    }

    @Deprecated
    public TicketInspireVideo getTicketInspireVideo() {
        return ticketInspireVideo;
    }

    @Deprecated
    public void setTicketInspireVideo(TicketInspireVideo ticketInspireVideo) {
        this.ticketInspireVideo = ticketInspireVideo;
    }

    public List<TicketInspireVideoCreative> getTicketInspireVideoCreatives() {
        return ticketInspireVideoCreatives;
    }

    public void setTicketInspireVideoCreatives(List<TicketInspireVideoCreative> ticketInspireVideoCreatives) {
        this.ticketInspireVideoCreatives = ticketInspireVideoCreatives;
    }

    public String getBxmId() {
        return bxmId;
    }

    public void setBxmId(String bxmId) {
        this.bxmId = bxmId;
    }

    public String getAlgorithmlName() {
        return algorithmlName;
    }

    public void setAlgorithmlName(String algorithmlName) {
        this.algorithmlName = algorithmlName;
    }

    public Integer getConsumeModal() {
        return consumeModal;
    }

    public void setConsumeModal(Integer consumeModal) {
        this.consumeModal = consumeModal;
    }

    public TicketAppExtend getAdTicketAppExtend() {
        return adTicketAppExtend;
    }

    public void setAdTicketAppExtend(TicketAppExtend adTicketAppExtend) {
        this.adTicketAppExtend = adTicketAppExtend;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
