package com.bxm.adsprod.facade.ssp;

import java.io.Serializable;
import java.util.List;

/**
 * <h3>为ssp提供图片广告券模型返回</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/10/28 19:22
 */
public class DirectTicketSsp implements Serializable {
    private static final long serialVersionUID = -765506832375486644L;

    /**
     * 广告响应id,和requestId保持一致.适合于spm
     */
    private String responseId;

    private String position;
    private String sspPositionId;
    private String uid;

    private String ticketId;
    /**
     * 落地页地址
     */
    private String url;
    /**
     * deeplink跳转地址
     */
    private String deeplinkUrl;
    /**
     * 落地页类型，1-下载类，2-表单类，3-deeplink表单类，4-deeplink下载类
     */
    private Short pageType;
    /**
     * 设备类型（1-安卓 2-ios 3-web）
     */
    private int appos;


    /**
     * Image元素的URL地址。
     */
    private String imgUrl;
    /**
     * Image元素的宽度，单位为像素。
     */
    private Integer w;
    /**
     * Image元素的⻓度，单位为像素。
     */
    private Integer h;
    private String assetsId;

    /**
     * DSP⼴告曝光监测信息
     */
    private List<String> impUrls;
    /**
     * DSP⼴告点击监测信息
     */
    private List<String> clickUrls;
    /**
     * deeplink调起开始
     */
    private List<String> dpStartTrackers;
    /**
     * deeplink调起成功
     */
    private List<String> dpSuccessTrackers;
    /**
     * deeplink调起失败
     */
    private List<String> dpFailTrackers;


    public String getResponseId() {
        return responseId;
    }

    public void setResponseId(String responseId) {
        this.responseId = responseId;
    }

    public String getTicketId() {
        return ticketId;
    }

    public void setTicketId(String ticketId) {
        this.ticketId = ticketId;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public int getAppos() {
        return appos;
    }

    public void setAppos(int appos) {
        this.appos = appos;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public Integer getW() {
        return w;
    }

    public void setW(Integer w) {
        this.w = w;
    }

    public Integer getH() {
        return h;
    }

    public void setH(Integer h) {
        this.h = h;
    }

    public String getAssetsId() {
        return assetsId;
    }

    public void setAssetsId(String assetsId) {
        this.assetsId = assetsId;
    }

    public List<String> getImpUrls() {
        return impUrls;
    }

    public void setImpUrls(List<String> impUrls) {
        this.impUrls = impUrls;
    }

    public List<String> getClickUrls() {
        return clickUrls;
    }

    public void setClickUrls(List<String> clickUrls) {
        this.clickUrls = clickUrls;
    }

    public String getSspPositionId() {
        return sspPositionId;
    }

    public void setSspPositionId(String sspPositionId) {
        this.sspPositionId = sspPositionId;
    }

    public String getDeeplinkUrl() {
        return deeplinkUrl;
    }

    public void setDeeplinkUrl(String deeplinkUrl) {
        this.deeplinkUrl = deeplinkUrl;
    }

    public Short getPageType() {
        return pageType;
    }

    public void setPageType(Short pageType) {
        this.pageType = pageType;
    }

    public List<String> getDpStartTrackers() {
        return dpStartTrackers;
    }

    public void setDpStartTrackers(List<String> dpStartTrackers) {
        this.dpStartTrackers = dpStartTrackers;
    }

    public List<String> getDpSuccessTrackers() {
        return dpSuccessTrackers;
    }

    public void setDpSuccessTrackers(List<String> dpSuccessTrackers) {
        this.dpSuccessTrackers = dpSuccessTrackers;
    }

    public List<String> getDpFailTrackers() {
        return dpFailTrackers;
    }

    public void setDpFailTrackers(List<String> dpFailTrackers) {
        this.dpFailTrackers = dpFailTrackers;
    }
}
