package com.bxm.adsprod.facade.ssp;

import com.bxm.adsprod.facade.ticket.TicketInspireTracker;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;
import java.math.BigInteger;

/**
 * 激励视频信息<br/>
 *
 * @author kerry.jiang
 * @date 2020/10/9 15:18
 */
public class TicketInspireSsp implements Serializable {

    private static final long serialVersionUID = 9132608548480991005L;

    /**
     * 广告券ID
     */
    private BigInteger id;
    /**
     * 广告响应id,和requestId保持一致
     */
    private String responseId;
    /**
     * 操作系统，1：安卓 2：IOS [3：windows phone(去除)] 4：未知
     */
    private Integer os;
    /**
     * 变现猫广告位id
     */
    private String position;
    /**
     * 变现猫素材ID
     */
    private BigInteger creativeId;
    /**
     * 落地页地址
     */
    private String url;
    /**
     * deeplink跳转地址
     */
    private String deeplinkUrl;
    /**
     * 落地页类型，1-下载类，2-表单类，3-deeplink表单类，4-deeplink下载类
     */
    private Short pageType;
    /**
     * APP包名
     */
    private String packageName;
    /**
     * 视频地址
     */
    private String videoUrl;
    /**
     * 封面地址
     */
    private String coverUrl;
    /**
     * 视频时长,秒
     */
    private Double videoDuration;
    /**
     * 视频方向(1.横版 2.竖版)
     */
    private Short videoDirection;
    /**
     * 视频的宽度，单位 px
     */
    private Integer videoWidth;
    /**
     * 视频的高度，单位 px
     */
    private Integer videoHeight;
    /**
     * 标题
     */
    private String title;
    /**
     * 广告内容
     */
    private String content;
    /**
     * icon地址
     */
    private String iconUrl;
    /**
     * 按钮文字
     */
    private String btnText;
    /**
     * 结束页内容链接
     */
    private String endUrl;
    /**
     * 监测信息
     */
    private TicketInspireTracker tracker;

    public BigInteger getId() {
        return id;
    }

    public void setId(BigInteger id) {
        this.id = id;
    }

    public String getResponseId() {
        return responseId;
    }

    public void setResponseId(String responseId) {
        this.responseId = responseId;
    }

    public Integer getOs() {
        return os;
    }

    public void setOs(Integer os) {
        this.os = os;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public BigInteger getCreativeId() {
        return creativeId;
    }

    public void setCreativeId(BigInteger creativeId) {
        this.creativeId = creativeId;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDeeplinkUrl() {
        return deeplinkUrl;
    }

    public void setDeeplinkUrl(String deeplinkUrl) {
        this.deeplinkUrl = deeplinkUrl;
    }

    public Short getPageType() {
        return pageType;
    }

    public void setPageType(Short pageType) {
        this.pageType = pageType;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getVideoUrl() {
        return videoUrl;
    }

    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
    }

    public String getCoverUrl() {
        return coverUrl;
    }

    public void setCoverUrl(String coverUrl) {
        this.coverUrl = coverUrl;
    }

    public Double getVideoDuration() {
        return videoDuration;
    }

    public void setVideoDuration(Double videoDuration) {
        this.videoDuration = videoDuration;
    }

    public Short getVideoDirection() {
        return videoDirection;
    }

    public void setVideoDirection(Short videoDirection) {
        this.videoDirection = videoDirection;
    }

    public Integer getVideoWidth() {
        return videoWidth;
    }

    public void setVideoWidth(Integer videoWidth) {
        this.videoWidth = videoWidth;
    }

    public Integer getVideoHeight() {
        return videoHeight;
    }

    public void setVideoHeight(Integer videoHeight) {
        this.videoHeight = videoHeight;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getIconUrl() {
        return iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getBtnText() {
        return btnText;
    }

    public void setBtnText(String btnText) {
        this.btnText = btnText;
    }

    public String getEndUrl() {
        return endUrl;
    }

    public void setEndUrl(String endUrl) {
        this.endUrl = endUrl;
    }

    public TicketInspireTracker getTracker() {
        return tracker;
    }

    public void setTracker(TicketInspireTracker tracker) {
        this.tracker = tracker;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
