/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.facade.ssp;

import com.bxm.adsprod.facade.ssp.DirectTicketSsp;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketAssets;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DirectTicketSspConvert {
    private static Logger logger = LoggerFactory.getLogger(DirectTicketSspConvert.class);

    public static DirectTicketSsp of(Ticket ticket) {
        DirectTicketSsp directTicketSsp = new DirectTicketSsp();
        if (null == ticket) {
            return null;
        }
        TicketAssets assets = ticket.getOfferAssets();
        if (null == assets) {
            if (logger.isWarnEnabled()) {
                logger.warn("ticket {} assets is null", (Object)ticket.getId());
            }
            return null;
        }
        directTicketSsp.setAssetsId(assets.getId().toString());
        directTicketSsp.setTicketId(ticket.getId().toString());
        String url = ticket.getUrl();
        if (StringUtils.isNotBlank((String)url)) {
            url = url.indexOf("?") > 0 ? url + "&bxm_id=" + ticket.getBxmId() : url + "?bxm_id=" + ticket.getBxmId();
        }
        directTicketSsp.setUrl(url);
        directTicketSsp.setImgUrl(assets.getImage());
        return directTicketSsp;
    }

    private static String date2String(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        return formatter.format(date);
    }
}

