package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;

/**
 * 落地页AB测试计划<br/>
 *
 * @author kerry.jiang
 * @date 2021/3/11 16:22
 */
public class TicketLandPlan implements Serializable {

    private static final long serialVersionUID = 4368329874159718574L;

    /**
     * 开启
     */
    public static final short STATUS_OPEN = 1;
    /**
     * 关闭
     */
    public static final short STATUS_CLOSE = 0;

    /**
     * 计划ID
     */
    private Long planId;
    /**
     * 状态,0.关闭 1.开启
     */
    private Short status;
    /**
     * 开始时段,HH:mm:ss标准格式,如：01:00:00
     */
    private String start;
    /**
     * 结束时段,HH:mm:ss标准格式,如：02:00:00
     */
    private String end;
    /**
     * 落地页信息
     */
    private List<TicketLand> lands;

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public Short getStatus() {
        return status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public String getStart() {
        return start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public List<TicketLand> getLands() {
        return lands;
    }

    public void setLands(List<TicketLand> lands) {
        this.lands = lands;
    }
}
