package com.bxm.adsprod.facade.ticket;

import com.bxm.warcar.validate.annotation.ValidateNotNull;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;
import java.util.List;

/**
 * <h3>激励视频请求对象</h3>
 *
 * @author kerry.jiang
 * @date 2019/8/5 17:55
 */
public class TicketInspireRequest implements Serializable {

    private static final long serialVersionUID = 1132577199900938728L;
    /**
     * 用户ID,判断曝光次数等
     */
    @ValidateNotNull
    private String uid;
    /**
     * 通过规则从imei/imeiMd5/androidId/androidIdMd5/oaid/idfa/idfaMd5中，获得该值
     */
    private String devUid;
    /**
     * imei
     */
    private String imei;
    /**
     * imei md5
     */
    private String imeiMd5;
    /**
     * 安卓id
     */
    private String anid;
    /**
     * 安卓id md5
     */
    private String anidMd5;
    /**
     * 安全联盟定义的用户唯一标识OAID
     */
    private String oaid;
    /**
     * idfa
     */
    private String idfa;
    /**
     * idfa md5
     */
    private String idfaMd5;
    /**
     * 平台
     * @see Platform
     */
    private int platform = Platform.MOBILE;
    /**
     * 用户设备操作系统
     * @see Os
     */
    private int os = Os.UNKNOWN;
    /**
     * 应用
     * @see App
     */
    private int app = App.UNKNOWN;
    /**
     * 用户IP地址
     */
    @ValidateNotNull
    private String ipaddress;
    /**
     * 广告位
     */
    @ValidateNotNull
    private String position;
    /**
     * 人群包,{人群包来源}-{外部人群包ID}
     */
    private List<String> tasks;
    /**
     * User-Agent
     */
    private String ua;
    /**
     * 屏幕方向
     * 1：竖屏
     * 2：横屏
     */
    private int screen = 1;
    /**
     * SSP广告位ID
     */
    private String sspPositionId;
    /**
     * 系统版本号，如：10.0.0
     */
    private String osv;

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getDevUid() {
        return devUid;
    }

    public void setDevUid(String devUid) {
        this.devUid = devUid;
    }

    public String getImeiMd5() {
        return imeiMd5;
    }

    public void setImeiMd5(String imeiMd5) {
        this.imeiMd5 = imeiMd5;
    }

    public String getAnid() {
        return anid;
    }

    public void setAnid(String anid) {
        this.anid = anid;
    }

    public String getAnidMd5() {
        return anidMd5;
    }

    public void setAnidMd5(String anidMd5) {
        this.anidMd5 = anidMd5;
    }

    public String getOaid() {
        return oaid;
    }

    public void setOaid(String oaid) {
        this.oaid = oaid;
    }

    public String getIdfa() {
        return idfa;
    }

    public void setIdfa(String idfa) {
        this.idfa = idfa;
    }

    public String getIdfaMd5() {
        return idfaMd5;
    }

    public void setIdfaMd5(String idfaMd5) {
        this.idfaMd5 = idfaMd5;
    }

    public int getPlatform() {
        return platform;
    }

    public void setPlatform(int platform) {
        this.platform = platform;
    }

    public int getOs() {
        return os;
    }

    public void setOs(int os) {
        this.os = os;
    }

    public int getApp() {
        return app;
    }

    public void setApp(int app) {
        this.app = app;
    }

    public String getIpaddress() {
        return ipaddress;
    }

    public void setIpaddress(String ipaddress) {
        this.ipaddress = ipaddress;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public List<String> getTasks() {
        return tasks;
    }

    public void setTasks(List<String> tasks) {
        this.tasks = tasks;
    }

    public String getUa() {
        return ua;
    }

    public void setUa(String ua) {
        this.ua = ua;
    }

    public int getScreen() {
        return screen;
    }

    public void setScreen(int screen) {
        this.screen = screen;
    }

    public String getSspPositionId() {
        return sspPositionId;
    }

    public void setSspPositionId(String sspPositionId) {
        this.sspPositionId = sspPositionId;
    }

    public String getOsv() {
        return osv;
    }

    public void setOsv(String osv) {
        this.osv = osv;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
