package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * 权益奖品
 * Created by zhengwangeng on 2021/04/25
 */
public class TicketRights implements Serializable {

    private static final long serialVersionUID = 9132608548480991005L;

    /**
     * ID
     */
    private BigInteger id;
    /**
     * 名称
     */
    private String name;
    /**
     * 图片地址
     */
    private String pictureUrl;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TicketRights that = (TicketRights) o;
        return Objects.equals(id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    public BigInteger getId() {
        return id;
    }

    public void setId(BigInteger id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPictureUrl() {
        return pictureUrl;
    }

    public void setPictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
