package com.bxm.adsprod.facade.media;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 广告位
 * @author allen
 * @date 2017-12-05
 */
public class Position implements Serializable {
    private static final long serialVersionUID = -7206395082189994836L;

    /**
     * 常规投放
     */
    public static final byte PUTINTYPE_NORMAL = 1;

    /**
     * 券码类投放
     */
    public static final byte PUTINTYPE_COUPON = 2;

    /**
     * 激励视频投放
     */
    public static final byte PUTINTYPE_INSPIRE = 3;

    private String id;
    private BigInteger mediaId;
    private String name;
    private String domainCode;

    /**
     * 状态
     * @see com.bxm.warcar.utils.Constants#YES
     * @see com.bxm.warcar.utils.Constants#NO
     */
    private Byte status;

    private Byte isCheck;

    /**
     * 媒体一级分类
     */
    private String mediaClassId;

    /**
     * 媒体二级分类
     */
    private  String mediaChildClassId;

    /**
     * 开发者id
     */
    private  String providerId;

    /**
     * （媒体）来源类型 (h5 app )
     */
    private  String mediaSysType;

    /**
     * 广告位入口场景（类别）（banal，浮标）
     */
    private  String positionEntrance;

    /**
     * 券码投放浮标位尺寸ID
     */
    private Long couponsIconSize;

    /**
     * 券码投放展示位尺寸ID
     */
    private Long couponsCreativeSize;

    /**
     * 投放方式类型：1常规投放，2券码类投放，3激励视频投放
     */
    private Byte putinType;

    /**
     * 上报地址
     */
    private String reportUrl;

    /**
     * 广告位场景（参考adsmedia-facade中PositionSceneEnum）
     * 1：互动广告
     * 2：自渲染
     * 3：浮标
     * 4：开屏
     * 5：信息流大图
     * 6：信息流小图
     * 7：信息流竖图
     * 8：信息流双文双图
     * 9：信息流组图
     * 10：推送
     * 11：激励视频
     */
    private Byte positionScene;

    /**
     * 广告位adx配置信息
     */
    private PositionAdx positionAdx;

    /**
     * 激励视频投放配置列表
     */
    private List<InspireVideoConfig> inspireVideoConfigs;

    public Position() { }

    public Position(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BigInteger getMediaId() {
        return mediaId;
    }

    public void setMediaId(BigInteger mediaId) {
        this.mediaId = mediaId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDomainCode() {
        return domainCode;
    }

    public void setDomainCode(String domainCode) {
        this.domainCode = domainCode;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public Byte getIsCheck() {
        return isCheck;
    }

    public void setIsCheck(Byte isCheck) {
        this.isCheck = isCheck;
    }

    public String getMediaClassId() {
        return mediaClassId;
    }

    public void setMediaClassId(String mediaClassId) {
        this.mediaClassId = mediaClassId;
    }

    public String getMediaChildClassId() {
        return mediaChildClassId;
    }

    public void setMediaChildClassId(String mediaChildClassId) {
        this.mediaChildClassId = mediaChildClassId;
    }

    public String getProviderId() {
        return providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public String getMediaSysType() {
        return mediaSysType;
    }

    public void setMediaSysType(String mediaSysType) {
        this.mediaSysType = mediaSysType;
    }

    public String getPositionEntrance() {
        return positionEntrance;
    }

    public void setPositionEntrance(String positionEntrance) {
        this.positionEntrance = positionEntrance;
    }

    public Long getCouponsIconSize() {
        return couponsIconSize;
    }

    public void setCouponsIconSize(Long couponsIconSize) {
        this.couponsIconSize = couponsIconSize;
    }

    public Long getCouponsCreativeSize() {
        return couponsCreativeSize;
    }

    public void setCouponsCreativeSize(Long couponsCreativeSize) {
        this.couponsCreativeSize = couponsCreativeSize;
    }

    public Byte getPutinType() {
        return putinType;
    }

    public void setPutinType(Byte putinType) {
        this.putinType = putinType;
    }

    public String getReportUrl() {
        return reportUrl;
    }

    public void setReportUrl(String reportUrl) {
        this.reportUrl = reportUrl;
    }

    public PositionAdx getPositionAdx() {
        return positionAdx;
    }

    public void setPositionAdx(PositionAdx positionAdx) {
        this.positionAdx = positionAdx;
    }

    public List<InspireVideoConfig> getInspireVideoConfigs() {
        return inspireVideoConfigs;
    }

    public void setInspireVideoConfigs(List<InspireVideoConfig> inspireVideoConfigs) {
        this.inspireVideoConfigs = inspireVideoConfigs;
    }

    public Byte getPositionScene() {
        return positionScene;
    }

    public void setPositionScene(Byte positionScene) {
        this.positionScene = positionScene;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

}
