package com.bxm.adsprod.facade.media;

import com.bxm.adsprod.facade.AdsprodFacadeConstants;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigInteger;
import java.util.Map;

/**
 * 广告位组织服务（流量包）
 *
 * @author allen
 * @since 1.0.0
 */
@FeignClient(name = AdsprodFacadeConstants.SERVER_NAME)
public interface PositionGroupService {

    /**
     * 获取这个广告券所配置的广告位组的今日消耗。
     *
     * @param ticketId
     * @return Key=广告位组ID、Value=今日消耗
     */
    @RequestMapping("/positionGroupService/getBudgetOfToday")
    Map<String, Long> getBudgetOfToday(@RequestParam("ticketId") BigInteger ticketId);

    /**
     * 获取这个广告券指定广告位组的今日消耗
     *
     * @param ticketId
     * @param groupId
     * @return
     */
    @RequestMapping("/positionGroupService/getBudgetOfTodayForGroup")
    long getBudgetOfToday(@RequestParam("ticketId") BigInteger ticketId,
                          @RequestParam("groupId") String groupId);

    /**
     * 为广告券的广告位组增加今日消耗。如果这个广告位在这个广告券中有组织，那么才会增加，否则直接返回 0
     *
     * @param ticketId
     * @param position
     * @param incValue
     * @return
     */
    @RequestMapping("/positionGroupService/incrementIfNecessary")
    long incrementIfNecessary(@RequestParam("ticketId") BigInteger ticketId,
                              @RequestParam("position") String position,
                              @RequestParam("incValue") long incValue);

    /**
     * 为广告券的广告位组增加今日消耗
     *
     * @param ticketId
     * @param groupId
     * @param incValue 增量值
     * @return
     */
    @RequestMapping("/positionGroupService/increment")
    long increment(@RequestParam("ticketId") BigInteger ticketId,
                   @RequestParam("groupId") String groupId,
                   @RequestParam("incValue") long incValue);
}
