package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;

import com.bxm.adsprod.facade.rules.Rule;

/**
 * tbl_ad_ticket_app_extend
 * @author 
 */
public class TicketAppExtend implements Serializable {

    private static final long serialVersionUID = 1L;

    //落地页类型，1-下载类，2-表单类，5-激励浏览
    /**
     * 下载类
     */
    public static final short PAGETYPE_DOWNLOAD = 1;
    /**
     * 表单类
     */
    public static final short PAGETYPE_FORM = 2;
    /**
     * 激励浏览
     */
    public static final short PAGETYPE_BROWSE = 5;

    //设备号定向
    /**
     * 不限
     */
    public final static String DEVICE_UNLIMITED = "1";

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 券id
     */
    private Long ticketId;

    /**
     * 落地页类型，1-下载类，2-表单类，5-激励浏览
     */
    private Short pageType;

    /**
     * 下载安装包的AppID/包名
     */
    private String packageName;

    /**
     * deeplink跳转地址
     */
    private String jumpUrl;

    /**
     * 曝光监测URL
     */
    private String viewUrl;

    /**
     * 点击监测URL
     */
    private String clickUrl;

    /**
     * 视频开始播放地址监测URL
     */
    private String videoPlayStartUrl;

    /**
     * 视频播放完成地址监测URL
     */
    private String videoPlayEndUrl;

    /**
     * deeplink吊起开始监测URL
     */
    private String deeplinkStartUrl;

    /**
     * deeplink吊起成功监测URL
     */
    private String deeplinkSuccessUrl;

    /**
     * deeplink吊起失败监测URL
     */
    private String deeplinkFailUrl;

    /**
     * 未获取到App列表时投放配率 0 ~ 100
     */
    private Integer appPackageRate;

    /**
     * 设备号定向 1.不限  2.仅设备号的流量
     * 已于20210118过期，后续将使用 deviceOrientation
     * 为什么不复用这个字段，只是变更下类型？ 因为怕其他系统也在使用adsprod-facde的老版本，导致数据不兼容
     */
    @Deprecated
    private Short deviceRule;

    /**
     * 设备号定向 1.不限  2-[type1],[type2].仅设备的流量
     */
    private String deviceOrientation;

    /**
     * 无包名投放配率 0到100
     */
    private Integer mediaAppPackageRate;

    /**
     * Adx无App ID 投放配率： 0到100
     */
    private Integer adxAppIdRate;

    /**
     * 百度标签定向，多个用逗号分隔
     */
    private String bdTagsOrientation;

    /**
     * 百度BES广告标签
     */
    private String bdTags;

    /**
     * ADX CPM成本
     */
    private Integer adxPrice;

    /**
     * adx出价类型
     * @see //com.bxm.adsmanager.model.enums.AdxPriceTypeEnum
     */
    private Short adxPriceType;

    /**
     * ADX成本日预算
     */
    private Integer adxBudgetDaily;

    /**
     * adx 出价目标cpa
     */
    private Integer adxTargetCpa;

    /**
     * 落地页最后一跳地址
     */
    private String landingPageEndJumpUrl;

    /**
     * 下载落地页ID
     */
    private Long downloadLandingPageId;

    /**
     * 人群包定向,多个逗号分隔
     */
    private String crowdPackageOrientation;

    /**
     * ADX 按时间段投放的配置。
     *
     * {startHour}-{endHour}-{limit}-{priceYuan},{startHour}-{endHour}-{limit}-{priceYuan}
     */
    private Rule timeBidding;

    /**
     * adxId 用于素材审核时判断是哪个Adx，也用于不同adx对素材进行不同的逻辑处理
     * @see //com.bxm.adsmanager.model.enums.AdxIdEnum
     */
    private Short adxId;

    /**
     * 风控：0关闭，1开启
     */
    private Short riskControl;

    /**
     * 首唤优化：0关闭，1开启
     */
    private Short firstCallOptimization;

    /**
     * 活动参与率，0-100之间的整数
     */
    private Short participationRate;

    /**
     * 操作系统版本定向（最低值）
     */
    private String osVersionOrientation;

    /**
     * 淘宝商详率，实际使用时需要除以1000
     */
    private Integer tbWaresDetailRate;

    /**
     * 淘宝首唤率*商详率，实际使用时需要除以1000
     */
    private Integer tbFirstCallAndWaresDetailRate;

    public Integer getTbFirstCallAndWaresDetailRate() {
        return tbFirstCallAndWaresDetailRate;
    }

    public void setTbFirstCallAndWaresDetailRate(Integer tbFirstCallAndWaresDetailRate) {
        this.tbFirstCallAndWaresDetailRate = tbFirstCallAndWaresDetailRate;
    }

    public Integer getTbWaresDetailRate() {
        return tbWaresDetailRate;
    }

    public void setTbWaresDetailRate(Integer tbWaresDetailRate) {
        this.tbWaresDetailRate = tbWaresDetailRate;
    }

    public String getOsVersionOrientation() {
        return osVersionOrientation;
    }

    public void setOsVersionOrientation(String osVersionOrientation) {
        this.osVersionOrientation = osVersionOrientation;
    }

    public Short getParticipationRate() {
        return participationRate;
    }

    public void setParticipationRate(Short participationRate) {
        this.participationRate = participationRate;
    }

    public Short getFirstCallOptimization() {
        return firstCallOptimization;
    }

    public void setFirstCallOptimization(Short firstCallOptimization) {
        this.firstCallOptimization = firstCallOptimization;
    }

    public Short getRiskControl() {
        return riskControl;
    }

    public void setRiskControl(Short riskControl) {
        this.riskControl = riskControl;
    }

    public Short getAdxId() {
        return adxId;
    }

    public void setAdxId(Short adxId) {
        this.adxId = adxId;
    }

    public String getCrowdPackageOrientation() {
        return crowdPackageOrientation;
    }

    public void setCrowdPackageOrientation(String crowdPackageOrientation) {
        this.crowdPackageOrientation = crowdPackageOrientation;
    }

    public Long getDownloadLandingPageId() {
        return downloadLandingPageId;
    }

    public void setDownloadLandingPageId(Long downloadLandingPageId) {
        this.downloadLandingPageId = downloadLandingPageId;
    }

    public Short getAdxPriceType() {
        return adxPriceType;
    }

    public void setAdxPriceType(Short adxPriceType) {
        this.adxPriceType = adxPriceType;
    }

    public String getLandingPageEndJumpUrl() {
        return landingPageEndJumpUrl;
    }

    public void setLandingPageEndJumpUrl(String landingPageEndJumpUrl) {
        this.landingPageEndJumpUrl = landingPageEndJumpUrl;
    }

    public Integer getMediaAppPackageRate() {
        return mediaAppPackageRate;
    }

    public void setMediaAppPackageRate(Integer mediaAppPackageRate) {
        this.mediaAppPackageRate = mediaAppPackageRate;
    }

    public Integer getAdxAppIdRate() {
        return adxAppIdRate;
    }

    public void setAdxAppIdRate(Integer adxAppIdRate) {
        this.adxAppIdRate = adxAppIdRate;
    }

    public String getBdTagsOrientation() {
        return bdTagsOrientation;
    }

    public void setBdTagsOrientation(String bdTagsOrientation) {
        this.bdTagsOrientation = bdTagsOrientation;
    }

    public String getBdTags() {
        return bdTags;
    }

    public void setBdTags(String bdTags) {
        this.bdTags = bdTags;
    }

    public Integer getAdxPrice() {
        return adxPrice;
    }

    public void setAdxPrice(Integer adxPrice) {
        this.adxPrice = adxPrice;
    }

    public Integer getAdxBudgetDaily() {
        return adxBudgetDaily;
    }

    public void setAdxBudgetDaily(Integer adxBudgetDaily) {
        this.adxBudgetDaily = adxBudgetDaily;
    }

    public Integer getAdxTargetCpa() {
        return adxTargetCpa;
    }

    public void setAdxTargetCpa(Integer adxTargetCpa) {
        this.adxTargetCpa = adxTargetCpa;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTicketId() {
        return ticketId;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }

    public Short getPageType() {
        return pageType;
    }

    public void setPageType(Short pageType) {
        this.pageType = pageType;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getJumpUrl() {
        return jumpUrl;
    }

    public void setJumpUrl(String jumpUrl) {
        this.jumpUrl = jumpUrl;
    }

    public String getViewUrl() {
        return viewUrl;
    }

    public void setViewUrl(String viewUrl) {
        this.viewUrl = viewUrl;
    }

    public String getClickUrl() {
        return clickUrl;
    }

    public void setClickUrl(String clickUrl) {
        this.clickUrl = clickUrl;
    }

    public String getVideoPlayStartUrl() {
        return videoPlayStartUrl;
    }

    public void setVideoPlayStartUrl(String videoPlayStartUrl) {
        this.videoPlayStartUrl = videoPlayStartUrl;
    }

    public String getVideoPlayEndUrl() {
        return videoPlayEndUrl;
    }

    public void setVideoPlayEndUrl(String videoPlayEndUrl) {
        this.videoPlayEndUrl = videoPlayEndUrl;
    }

    public String getDeeplinkStartUrl() {
        return deeplinkStartUrl;
    }

    public void setDeeplinkStartUrl(String deeplinkStartUrl) {
        this.deeplinkStartUrl = deeplinkStartUrl;
    }

    public String getDeeplinkSuccessUrl() {
        return deeplinkSuccessUrl;
    }

    public void setDeeplinkSuccessUrl(String deeplinkSuccessUrl) {
        this.deeplinkSuccessUrl = deeplinkSuccessUrl;
    }

    public String getDeeplinkFailUrl() {
        return deeplinkFailUrl;
    }

    public void setDeeplinkFailUrl(String deeplinkFailUrl) {
        this.deeplinkFailUrl = deeplinkFailUrl;
    }

    public Integer getAppPackageRate() {
        return appPackageRate;
    }

    public void setAppPackageRate(Integer appPackageRate) {
        this.appPackageRate = appPackageRate;
    }

    public Short getDeviceRule() {
        return deviceRule;
    }

    public void setDeviceRule(Short deviceRule) {
        this.deviceRule = deviceRule;
    }

    public String getDeviceOrientation() {
        return deviceOrientation;
    }

    public void setDeviceOrientation(String deviceOrientation) {
        this.deviceOrientation = deviceOrientation;
    }

    public Rule getTimeBidding() {
        return timeBidding;
    }

    public void setTimeBidding(Rule timeBidding) {
        this.timeBidding = timeBidding;
    }
}