package com.bxm.adsprod.model.so.rules;

import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Sets;

/**
 * <p>
 *     广告券黑白名单通用规则
 * </p>
 * <pre>
 *     {type}-{item},{item},{item}
 *
 *     type=类型。1- 白名单、2- 黑名单
 *     item=名单
 * </pre>
 *
 * @author kerry.jiang
 * @date 2021/5/11 10:29
 */
public class TicketWhiteBlackSo extends RuleSo {

    private static final Logger LOGGER = LoggerFactory.getLogger(TicketWhiteBlackSo.class);

    public static final String TYPE_WHITELIST = "1";
    public static final String TYPE_BLACKLIST = "2";

    private static final int VALUE_SPLIT_SIZE = 2;

    /**
     * 是否为黑名单
     */
    @JSONField(deserialize = false, serialize = false)
    private boolean blackList;
    /**
     * 名单
     */
    @JSONField(deserialize = false, serialize = false)
    private Set<String> items = Sets.newHashSet();

    @Override
    public void setRuleValue(String ruleValue) {
        super.setRuleValue(ruleValue);

        String value = super.getRuleValue();
        if (StringUtils.isBlank(value)) {
            return;
        }

        String[] strings = StringUtils.split(value, '-');
        if (strings.length < VALUE_SPLIT_SIZE) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Invalid value format of 'TicketWhiteBlackSo',targetId={}, ruleType={}, ruleValue={}.",
                        targetId, ruleType, ruleValue);
            }
            return;
        }
        if (strings.length > VALUE_SPLIT_SIZE) {
            int startIndex = value.indexOf('-');
            strings = new String[2];
            strings[0] = StringUtils.substring(value, 0, startIndex);
            strings[1] = StringUtils.substring(value, startIndex + 1, value.length());
        }

        String type = strings[0];
        String infos = strings[1];

        this.blackList = (StringUtils.equals(TYPE_BLACKLIST, type));
        String[] infoArray = StringUtils.split(infos, ',');

        for (String s : infoArray) {
            this.items.add(s);
        }
    }

    public boolean isBlackList() {
        return blackList;
    }

    public Set<String> getItems() {
        return items;
    }
}
