package com.bxm.adsprod.facade.media.sdk;

import com.bxm.adsprod.facade.resolve.UrlParam;
import com.bxm.adsprod.facade.resolve.UseFixedValue;
import com.bxm.warcar.validate.annotation.ValidateNotNull;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;

/**
 * <h3>SDK初始化上报请求参数</h3>
 * @author: zm
 * @Date: 2019/8/1 0001 16:14
 * @Description: 视频上报设备公参
 */
public class EquipmentRedordRequest implements Serializable {

    private static final long serialVersionUID = -1L;

    /**
     * 设备id
     */
    @UrlParam(urlParamName = "devid")
    @ValidateNotNull
    private String deviceid;
    /**
     * IMEI（安卓）
     */
    @UrlParam(urlParamName = "imei")
    private String imei;
    /**
     * IDFA（IOS）
     */
    @UrlParam(urlParamName = "idfa")
    private String idfa;
    /**
     * mac地址
     */
    @UrlParam(urlParamName = "mac")
    private String mac;
    /**
     * IP地址
     */
    @UrlParam(urlParamName = "ip")
    private String ipaddress;
    /**
     * 经度
     */
    @UrlParam(urlParamName = "lon")
    private String lon;
    /**
     * 纬度
     */
    @UrlParam(urlParamName = "lat")
    private String lat;
    /**
     * 设备型号(机型)
     */
    @UrlParam(urlParamName = "devm")
    private String equipmentModel;
    /**
     * 设备品牌
     */
    @UrlParam(urlParamName = "devb")
    private String equipmentBrand;
    /**
     * 设备类型（手机、平板）
     * 1：手机
     * 2：平板
     */
    @UrlParam(urlParamName = "devt")
    private String equipmentType;
    /**
     * 内存
     */
    @UrlParam(urlParamName = "dmem")
    private Double memory;
    /**
     * 存储空间
     */
    @UrlParam(urlParamName = "dstg")
    private Double storageSpace;
    /**
     * cpu型号
     */
    @UrlParam(urlParamName = "cpu")
    private String cpuModel;
    /**
     * 安装应用列表
     */
    @UrlParam(urlParamName = "appl")
    private String applications;
    /**
     * 安卓或者ios系统版本号
     */
    @UrlParam(urlParamName = "osv")
    private String systemVersion;
    /**
     * 安装应用的包名
     */
    @UrlParam(urlParamName = "pack")
    @ValidateNotNull
    private String packageName;
    /**
     * 手机网络运行商（SDK1.3.0及以下传值为具体描述信息）
     * 0：未知
     * 1：移动
     * 2：联通
     * 3：电信
     */
    @UrlParam(urlParamName = "isp")
    private String networkOperator;
    /**
     * sdk版本
     */
    @UrlParam(urlParamName = "sdkv")
    private String sdkVersion;
    /**
     * appKey
     */
    @UrlParam(urlParamName = "appkey")
    @ValidateNotNull
    private String appkey;
    /**
     * 联网方式（SDK1.3.0及以下传值为具体描述信息）
     * 0: 未知
     * 1: 以太网
     * 2: WIFI
     * 3: 2G
     * 4: 3G
     * 5: 4G
     * 6: 5G
     */
    @UrlParam(urlParamName = "net")
    private String net;
    /**
     * 埋点默认值,不可更改(埋点类型)
     */
    @UrlParam(urlParamName = "mt")
    @UseFixedValue("13001")
    private String mt;
    /**
     * SDK类型
     * 1：初始版本
     * 2：流量分配版本
     */
    @UrlParam(urlParamName = "sdkType")
    private Integer sdkType;
    /**
     * 系统
     * 1：安卓
     * 2：IOS
     */
    @UrlParam(urlParamName = "os")
    private Byte os;
    /**
     * android id（安卓）
     * SDK1.3.1
     */
    private String androidId;
    /**
     * open device id（安卓10.0以上）
     * SDK1.3.1
     */
    private String odid;
    /**
     * 设备屏幕高度
     * SDK1.3.1
     */
    private Integer screenHeight;
    /**
     * 设备屏幕宽度
     * SDK1.3.1
     */
    private Integer screenWidth;

    public String getDeviceid() {
        return deviceid;
    }

    public void setDeviceid(String deviceid) {
        this.deviceid = deviceid;
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getMac() {
        return mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public String getIpaddress() {
        return ipaddress;
    }

    public void setIpaddress(String ipaddress) {
        this.ipaddress = ipaddress;
    }

    public String getEquipmentModel() {
        return equipmentModel;
    }

    public void setEquipmentModel(String equipmentModel) {
        this.equipmentModel = equipmentModel;
    }

    public String getEquipmentBrand() {
        return equipmentBrand;
    }

    public void setEquipmentBrand(String equipmentBrand) {
        this.equipmentBrand = equipmentBrand;
    }

    public Double getMemory() {
        return memory;
    }

    public void setMemory(Double memory) {
        this.memory = memory;
    }

    public Double getStorageSpace() {
        return storageSpace;
    }

    public void setStorageSpace(Double storageSpace) {
        this.storageSpace = storageSpace;
    }

    public String getCpuModel() {
        return cpuModel;
    }

    public void setCpuModel(String cpuModel) {
        this.cpuModel = cpuModel;
    }

    public String getEquipmentType() {
        return equipmentType;
    }

    public void setEquipmentType(String equipmentType) {
        this.equipmentType = equipmentType;
    }

    public String getSystemVersion() {
        return systemVersion;
    }

    public void setSystemVersion(String systemVersion) {
        this.systemVersion = systemVersion;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getNetworkOperator() {
        return networkOperator;
    }

    public void setNetworkOperator(String networkOperator) {
        this.networkOperator = networkOperator;
    }

    public String getSdkVersion() {
        return sdkVersion;
    }

    public void setSdkVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public String getAppkey() {
        return appkey;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getApplications() {
        return applications;
    }

    public void setApplications(String applications) {
        this.applications = applications;
    }

    public String getIdfa() {
        return idfa;
    }

    public void setIdfa(String idfa) {
        this.idfa = idfa;
    }

    public String getLon() {
        return lon;
    }

    public void setLon(String lon) {
        this.lon = lon;
    }

    public String getLat() {
        return lat;
    }

    public void setLat(String lat) {
        this.lat = lat;
    }

    public String getNet() {
        return net;
    }

    public void setNet(String net) {
        this.net = net;
    }


    public String getMt() {
        return mt;
    }

    public void setMt(String mt) {
        this.mt = mt;
    }

    public Integer getSdkType() {
        return sdkType;
    }

    public void setSdkType(Integer sdkType) {
        this.sdkType = sdkType;
    }

    public Byte getOs() {
        return os;
    }

    public void setOs(Byte os) {
        this.os = os;
    }

    public String getAndroidId() {
        return androidId;
    }

    public void setAndroidId(String androidId) {
        this.androidId = androidId;
    }

    public String getOdid() {
        return odid;
    }

    public void setOdid(String odid) {
        this.odid = odid;
    }

    public Integer getScreenHeight() {
        return screenHeight;
    }

    public void setScreenHeight(Integer screenHeight) {
        this.screenHeight = screenHeight;
    }

    public Integer getScreenWidth() {
        return screenWidth;
    }

    public void setScreenWidth(Integer screenWidth) {
        this.screenWidth = screenWidth;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}