package com.bxm.adsprod.facade.ticket;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;
import java.math.BigInteger;

/**
 * <h3>监测数据上报请求对象</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/07
 */
public class S2sTrackRequest implements Serializable {

    private static final long serialVersionUID = 1132577199900938728L;

    /**
     * 上报类型
     * 1、曝光
     * 2、点击
     * 3、开始播放
     * 4、播放完成
     */
    private Integer type;
    /**
     * 时间戳
     */
    private Long timestamp;
    /**
     * 变现猫ID
     */
    private String bxm_id;
    /**
     * 系统类型
     * 1: ANDROID
     * 2: IOS
     */
    private Integer os;
    /**
     * IDFA
     */
    private String idfa;
    /**
     * IMEI
     */
    private String imei;
    /**
     * 用户ID
     */
    private String uid;
    /**
     * 广告位ID
     */
    private String position_id;
    /**
     * IP地址
     */
    private String ip;
    /**
     * user agent
     */
    private String ua;
    /**
     * 券ID
     */
    private BigInteger ticket_id;

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public String getBxm_id() {
        return bxm_id;
    }

    public void setBxm_id(String bxm_id) {
        this.bxm_id = bxm_id;
    }

    public Integer getOs() {
        return os;
    }

    public void setOs(Integer os) {
        this.os = os;
    }

    public String getIdfa() {
        return idfa;
    }

    public void setIdfa(String idfa) {
        this.idfa = idfa;
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getPosition_id() {
        return position_id;
    }

    public void setPosition_id(String position_id) {
        this.position_id = position_id;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getUa() {
        return ua;
    }

    public void setUa(String ua) {
        this.ua = ua;
    }

    public BigInteger getTicket_id() {
        return ticket_id;
    }

    public void setTicket_id(BigInteger ticket_id) {
        this.ticket_id = ticket_id;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
