package com.bxm.adsprod.facade.ticket.rtb;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@Data
public class PositionRtb implements Serializable {

    private static final long serialVersionUID = -919819840121789217L;

    public static final byte CONVERSION_CONTROL_TYPE_CVR = 1;
    public static final byte CONVERSION_CONTROL_TYPE_RATE = 2;

    public interface AllSourceType {

        int KUAISHOU = 1;
        int BAIDU = 2;
        int GUANGDIANTONG = 3;
        int JULIANGYINQING = 4;
        int IQIYI = 5;
        int WANGYIYOUDAO = 6;
        int UC = 7;
        int XIMALAYA = 8;
        int JIGUANG=9;
        int ZFB=10;
        int QTT=11;
        int JIGUANGADX=12;
        int XIAOMI=13;
        int VIVO=14;
        int MEITUAN=15;
        int WIFI =16;
        int WEIBO =17;
        int BIGO = 18;
        int OPPO = 19;
        int SIGMOB =20;
        int DOMOB = 21;
        int MINTEGRAL = 22;
        int ADBEE = 23;
        int BiliBili = 24;

    }

    private String positionId;

    /**
     * 秘钥token
     */
    private String token;

    /**
     * 客户ID
     */
    private String  customerId;

    /**
     * 数据源id
     */
    private String sourceId;

    /**
     * 1 浅层  2 深层
     */
    private Byte targetType;

    /**
     * rtb 单层目标
     */
    private String targetOneRtb;

    /**
     * rtb 深层目标
     */
    private String targetTwoRtb;

    /**
     * 头部券jsonn
     * 助力器json
     */
    private String headTicketJson;
    private String helpTicketJson;

    /**
     * 来源 1快手 2 百度
     */
    private Integer sourceType;

    /**
     * 活动浅层
     * 活动深层
     */
    private String activityOne;
    private String activityTwo;

    /**
     * CVR 回传控制
     */
    private List<CvrControl> cvrControls;
    /**
     * 广告券 回传控制
     */
    private List<SpeedControl> ticketControls;
    /**
     * 活动 回传控制
     */
    private List<SpeedControl> activityControls;

    /**
     * 比例 回传控制
     */
    private List<CvrControl> rateControls;

    /**
     * 转化控制类型 1.cvr控制 2.扣量回传
     */
    private Byte conversionControlType;

    @Data
    public static class TargetBXM {
        /**
         * bxm 单层目标
         * bxm 深层目标
         * 券列表，多个以逗号隔开
         * 流量分配
         */
        private Integer targetOneBxm;
        private Integer targetTwoBxm;
        private String ticketIds;
        private Integer flow;
    }

    @Data
    public static class CvrControl {
        /**
         * 自增主键
         */
        private Long id;
        /**
         * <p>广告组 ID，一般根据不同的平台有不同的含义。</p>
         * <p>可以为空，为空则表示匹配当前广告位任何广告组 ID。如果冲突，则优先取 广告组 ID 粒度的配置。</p>
         */
        private String adGroupId;
        /**
         * <p>控制的 cvr、控制的比例，这取决于控制的类型。</p>
         *
         * <p>浅层转化 扣量比例，取值范围：0-1，1 表示 100%。</p>
         */
        private double cvr;
        /**
         * <p>深层转化 扣量比例，取值范围：0-1，1 表示 100%。</p>
         * 从这个<a href="https://alidocs.dingtalk.com/i/team/BpLmkK6448BpPm2g/docs/BpLmkwPNA0r1vm2g">版本「Mintegral和爱奇艺支持双目标扣量」</a>开始使用的
         */
        private double deepCvr;
        /**
         * 开始时间，格式：HH:mm:ss
         */
        private String startTime;
        /**
         * 结束时间，格式：HH:mm:ss
         */
        private String endTime;
        /**
         * 启用状态
         */
        private boolean enable;
    }

    @Data
    public static class SpeedControl {

        private Long id;
        /**
         * <p>广告组 ID，一般根据不同的平台有不同的含义。</p>
         * <p>可以为空，为空则表示匹配当前广告位任何广告组 ID。如果冲突，则优先取 广告组 ID 粒度的配置。</p>
         */
        private String adGroupId;
        /**
         * 广告券 ID，活动配置下没有值。
         */
        private String adTicketId;
        /**
         * 行为类型
         */
        private String convType;
        /**
         * 控制回传数量
         */
        private Integer count;
        /**
         * 启用日期，格式：yyyy-MM-dd
         */
        private String date;
        /**
         * 开始时间，格式：HH:mm:ss
         */
        private String startTime;
        /**
         * 结束时间，格式：HH:mm:ss
         */
        private String endTime;
        /**
         * 启用状态
         */
        private boolean enable;
    }

    public boolean isKuaishou() {
        return this.getSourceType() == AllSourceType.KUAISHOU;
    }

    public boolean isBaidu() {
        return this.getSourceType() == AllSourceType.BAIDU;
    }

    public boolean isGuangDianTong() {
        return this.getSourceType() == AllSourceType.GUANGDIANTONG;
    }

    /**
     * 是 CVR 控制类型
     * @return 当没有指定 {@link #conversionControlType} 时，默认：true
     * @see #CONVERSION_CONTROL_TYPE_CVR
     */
    public boolean isCvrControl() {
        if (Objects.isNull(this.conversionControlType)) {
            // 当没有值时，默认为 CONVERSION_CONTROL_TYPE_CVR
            return true;
        }
        return Objects.equals(this.conversionControlType, CONVERSION_CONTROL_TYPE_CVR);
    }

    /**
     * 是 比例 控制类型
     * @return 当没有指定 {@link #conversionControlType} 时，默认：false
     * @see #CONVERSION_CONTROL_TYPE_RATE
     */
    public boolean isDeductionControl() {
        return Objects.equals(this.conversionControlType, CONVERSION_CONTROL_TYPE_RATE);
    }
}