package com.bxm.adsprod.model.so.rules;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;

import java.util.List;

/**
 * 广告券地域规则
 * <pre>
 *     {city}
 * </pre>
 * @author allen
 * @date 2017-12-06
 */
public class TicketRegionRuleSo extends RuleSo {

    @JSONField(deserialize = false, serialize = false)
    private List<String> entries = Lists.newArrayList();

    public List<String> getEntries() {
        return entries;
    }

    @Override
    public void setRuleValue(String ruleValue) {
        super.setRuleValue(ruleValue);

        String value = super.getRuleValue();

        if (StringUtils.isBlank(value)) {
            {
                return;
            }
        }

        String[] items = StringUtils.split(value, ',');
        for (String item : items) {
            this.entries.add(item);
        }
    }
}
