package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

/**
 * <h3>CPA广告券消耗</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/13
 */
public class TicketProfitForCpa implements Serializable {

    private static final long serialVersionUID = 6303778252221622178L;

    private BigInteger ticketId;
    private String date;
    private BigDecimal profit;
    private String datePattern = "yyyy-MM-dd";

    public TicketProfitForCpa() {
    }

    public TicketProfitForCpa(BigInteger ticketId, String date, BigDecimal profit) {
        this.ticketId = ticketId;
        this.date = date;
        this.profit = profit;
    }

    public BigInteger getTicketId() {
        return ticketId;
    }

    public void setTicketId(BigInteger ticketId) {
        this.ticketId = ticketId;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public BigDecimal getProfit() {
        return profit;
    }

    public void setProfit(BigDecimal profit) {
        this.profit = profit;
    }

    public String getDatePattern() {
        return datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }
}
