package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;
import java.util.Objects;

/**
 * 直投素材
 * @author bcc
 *
 */
public class DirectMaterial  implements Serializable {

    private Long id;

    private String url;

    /**
     * 主标题
     */
    private String title;

    /**
     * 副标题
     */
    private String subTitle;

    private String size;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }


    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSubTitle() {
        return subTitle;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }


    public String getSize() {
        return size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o){
            return true;
        }
        if (o == null || getClass() != o.getClass()){
            return false;
        }
        DirectMaterial material = (DirectMaterial) o;
        return Objects.equals(id, material.id) &&
                Objects.equals(url, material.url) &&
                Objects.equals(title, material.title) &&
                Objects.equals(subTitle, material.subTitle) &&
                Objects.equals(size, material.size);
    }

    @Override
    public int hashCode() {

        return Objects.hash(id, url, title, subTitle, size);
    }
}
