package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import com.alibaba.fastjson.annotation.JSONField;
import com.bxm.adsprod.facade.tag.Tag;
import com.bxm.adsprod.facade.ticket.inspirevideo.OfferInspireVideo;
import com.bxm.adsprod.facade.ticket.inspirevideo.TicketInspireVideo;
import com.bxm.adsprod.facade.ticket.inspirevideo.TicketInspireVideoCreative;
import com.bxm.warcar.utils.Constants;

/**
 * @author allen
 * @since 1.0.0
 */
public class TicketCache implements Serializable, RightsTicket {

    private static final long serialVersionUID = 5350115397458848883L;
    private BigInteger id;
    private Integer userGradePassScore;
    private Byte type;
    private String domainCode;
    private List<Tag> tags;
    private List<TicketOnoff> onoffs;
    private List<TicketOs> oss;
    @Deprecated
    private Byte isSupportWechat;
    private List<Integer> apps;
    private Byte status;
    private Integer pauseReason;
    /**
     * 结算方式：1- CPC、2- CPA、3-OCPC、4- CPM
     */
    private Byte settleType;
    /**
     * CPA 预期价
     */
    private Integer cpaPrice;
    /**
     * 底价
     */
    private Integer floorPrice;
    /**
     * 是否是OCPC广告
     */
    private Integer ocpc;
    /**
     * 屏蔽阈值
     */
    private Integer closeThreshold;
    /**
     * 广告主 ID
     */
    private Long groupId;

    /**
     * 关闭时间,主要用于数据统计
     */
    private Date closeTime;

    /**
     * 独立成本
     */
    private Double standaloneCost;

    @JSONField(serialize = false, deserialize = false)
    private Integer sequence;

    /**
     * 票券扩展信息
     */
    private TicketCouponsInfo ticketCouponsInfo;

    /**
     * 票券素材列表
     */
    private List<TicketAssetsCoupons> ticketAssetsCoupons;

    /**
     * 激励视频信息
     * 老数据有值，被编辑过的券已存储到 {@link TicketAppExtend} 中
     */
    @Deprecated
    private TicketInspireVideo ticketInspireVideo;

    /**
     * 激励视频素材列表
     */
    private List<TicketInspireVideoCreative> ticketInspireVideoCreatives;

    /**
     *  bxmId
     */
    private String bxmId;

    /**
     * 算法名称
     */
    private String algorithmlName;

    /**
     * 投放模式
     */
    private Integer consumeModal;

    /**
     * 外部激励视频广告信息（有道使用）
     */
    private OfferInspireVideo offerInspireVideo;
    /**
     * 本次获取广告券所对应的素材（有道使用）
     */
    private TicketAssets offerAssets;
    private String url;

    private String taobaoClickurl;

    private String bestAssetsId;

    /**
     * 券app相关扩展信息
     */
    private TicketAppExtend adTicketAppExtend;

    /**
     * 券支持的广告位场景列表
     */
    private List<TicketPositionScene> positionScenes;

    /**
     * 可用素材列表（互动广告场景过滤时，才会赋值）
     */
    private List<TicketAssets> availableAssets;

    /**
     * 素材流量分配类型,0.算法优选 1.手动配置
     */
    private Short assetsDistribute;

    /**
     * 频次扩容时间
     */
    private Date timesEnlargeDate;

    /**
     * 权益奖品ID
     */
    private BigInteger rightsId;

    /**
     * 返回的权益的集合
     */
    private List<TicketRights> ticketRightsList;

    /**
     * 麒麟域名组ID
     */
    private String kylinGroupId;

    /**
     * 深层目标cpa
     */
    private Integer deepCpaPrice;

    /**
     * 深层目标对应的行为类型
     */
    private Integer deepExpectActionType;
    /**
     * 效果监控转化目标（OCPA必传）
     */
    private Short targetConvType;

    /**
     *  rtb对应的开发者
     */
    private String rtbAppKey;

    /**
     * 广告&活动标签 用于直投集合页活动
     */
    private Integer ticketActivityMatchTag;

    private TicketRtaExtend rtaExtend;


    /**
     * 券组ID，埋点用
     */
    private String ticketGroupId;
    /**
     * 埋点用
     * 发券次序
     * 是否探索出价
     */
    private Long userBxmCount;
    private Integer exploreType;

    /**
     * 目标对应的行为类型
     */
    private Integer expectActionType;

    /**
     * 是否去重有效点击 0.是 1.否
     */
    private Byte deduplicateValidClick;


    /**
     * 算法优化目标（1单目标优化 2 双目标优化）
     */
    private Short algoTarget;

    @Override
    public BigInteger getTicketId() {
        return this.id;
    }

    @JSONField(serialize = false, deserialize = false)
    public boolean isNormalType() {
        return null != type && type == Ticket.TYPE_NORMAL;
    }
    @JSONField(serialize = false, deserialize = false)
    public boolean isStandbysType() {
        return null != type && type == Ticket.TYPE_STANDBY;
    }
    @JSONField(serialize = false, deserialize = false)
    public boolean isDSP() {
        return null != type && type == Ticket.TYPE_DSP;
    }
    @JSONField(serialize = false, deserialize = false)
    public boolean isRTA() {
        return null != type && type == Ticket.TYPE_RTA;
    }
    @JSONField(serialize = false, deserialize = false)
    public boolean isSupportedOs(int os) {
        if (CollectionUtils.isEmpty(oss)) {
            return false;
        }
        for (TicketOs ticketOs : oss) {
            if (ticketOs.getSupportOs() == os) {
                return true;
            }
        }
        return false;
    }

    @JSONField(serialize = false, deserialize = false)
    public boolean isSupportedPositionScene(Byte positionScene) {
        if (CollectionUtils.isEmpty(positionScenes)) {
            //不限
            return true;
        }
        for (TicketPositionScene scene : positionScenes) {
            if (scene.getScene().equals(positionScene)) {
                return true;
            }
        }
        return false;
    }

    @JSONField(serialize = false, deserialize = false)
    public boolean isCarrier(int a) {
        if (CollectionUtils.isEmpty(apps)) {
            return false;
        }
        for (Integer app : apps) {
            if (app == a) {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    @JSONField(serialize = false, deserialize = false)
    public boolean isSupportedWechat() {
        return null != isSupportWechat && isSupportWechat == Constants.YES;
    }

    @JSONField(serialize = false, deserialize = false)
    public boolean isOcpc() {
        return null != ocpc && ocpc == Constants.YES;
    }
    @JSONField(serialize = false, deserialize = false)
    public boolean isOcpa() {
        return null != settleType &&  settleType == Ticket.SETTLE_TYPE_OCPA;
    }
    public String getDomainCode() {
        return domainCode;
    }

    public void setDomainCode(String domainCode) {
        this.domainCode = domainCode;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public BigInteger getId() {
        return id;
    }

    public void setId(BigInteger id) {
        this.id = id;
    }

    public Integer getUserGradePassScore() {
        return userGradePassScore;
    }

    public void setUserGradePassScore(Integer userGradePassScore) {
        this.userGradePassScore = userGradePassScore;
    }

    public List<Tag> getTags() {
        return tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public List<TicketOnoff> getOnoffs() {
        return onoffs;
    }

    public void setOnoffs(List<TicketOnoff> onoffs) {
        this.onoffs = onoffs;
    }

    public List<TicketOs> getOss() {
        return oss;
    }

    public void setOss(List<TicketOs> oss) {
        this.oss = oss;
    }

    public Byte getIsSupportWechat() {
        return isSupportWechat;
    }

    public void setIsSupportWechat(Byte isSupportWechat) {
        this.isSupportWechat = isSupportWechat;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public Integer getPauseReason() {
        return pauseReason;
    }

    public void setPauseReason(Integer pauseReason) {
        this.pauseReason = pauseReason;
    }

    public Integer getSequence() {
        return sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public Integer getCpaPrice() {
        return cpaPrice;
    }

    public void setCpaPrice(Integer cpaPrice) {
        this.cpaPrice = cpaPrice;
    }

    public Integer getTicketActivityMatchTag() {
        return ticketActivityMatchTag;
    }

    public void setTicketActivityMatchTag(Integer ticketActivityMatchTag) {
        this.ticketActivityMatchTag = ticketActivityMatchTag;
    }

    public Integer getFloorPrice() {
        return floorPrice;
    }

    public String getTaobaoClickurl() {
        return taobaoClickurl;
    }

    public void setTaobaoClickurl(String taobaoClickurl) {
        this.taobaoClickurl = taobaoClickurl;
    }

    public void setFloorPrice(Integer floorPrice) {
        this.floorPrice = floorPrice;
    }

    public Integer getOcpc() {
        return ocpc;
    }

    public OfferInspireVideo getOfferInspireVideo() {
        return offerInspireVideo;
    }

    public void setOfferInspireVideo(OfferInspireVideo offerInspireVideo) {
        this.offerInspireVideo = offerInspireVideo;
    }

    public TicketAssets getOfferAssets() {
        return offerAssets;
    }

    public void setOfferAssets(TicketAssets offerAssets) {
        this.offerAssets = offerAssets;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setOcpc(Integer ocpc) {
        this.ocpc = ocpc;
    }

    public Integer getCloseThreshold() {
        return closeThreshold;
    }

    public void setCloseThreshold(Integer closeThreshold) {
        this.closeThreshold = closeThreshold;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public List<Integer> getApps() {
        return apps;
    }

    public void setApps(List<Integer> apps) {
        this.apps = apps;
    }
    public Date getCloseTime() {
        return closeTime;
    }

    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    public Double getStandaloneCost() {
        return null==standaloneCost?0.0:standaloneCost;
    }

    public void setStandaloneCost(Double standaloneCost) {
        this.standaloneCost = standaloneCost;
    }

    public TicketCouponsInfo getTicketCouponsInfo() {
        return ticketCouponsInfo;
    }

    public void setTicketCouponsInfo(TicketCouponsInfo ticketCouponsInfo) {
        this.ticketCouponsInfo = ticketCouponsInfo;
    }

    public List<TicketAssetsCoupons> getTicketAssetsCoupons() {
        return ticketAssetsCoupons;
    }

    public void setTicketAssetsCoupons(List<TicketAssetsCoupons> ticketAssetsCoupons) {
        this.ticketAssetsCoupons = ticketAssetsCoupons;
    }

    @Deprecated
    public TicketInspireVideo getTicketInspireVideo() {
        return ticketInspireVideo;
    }

    @Deprecated
    public void setTicketInspireVideo(TicketInspireVideo ticketInspireVideo) {
        this.ticketInspireVideo = ticketInspireVideo;
    }

    public List<TicketInspireVideoCreative> getTicketInspireVideoCreatives() {
        return ticketInspireVideoCreatives;
    }

    public void setTicketInspireVideoCreatives(List<TicketInspireVideoCreative> ticketInspireVideoCreatives) {
        this.ticketInspireVideoCreatives = ticketInspireVideoCreatives;
    }

    public String getBxmId() {
        return bxmId;
    }

    public void setBxmId(String bxmId) {
        this.bxmId = bxmId;
    }

    public String getAlgorithmlName() {
        return algorithmlName;
    }

    public void setAlgorithmlName(String algorithmlName) {
        this.algorithmlName = algorithmlName;
    }

    public Integer getConsumeModal() {
        return consumeModal;
    }

    public void setConsumeModal(Integer consumeModal) {
        this.consumeModal = consumeModal;
    }

    public TicketAppExtend getAdTicketAppExtend() {
        return adTicketAppExtend;
    }

    public void setAdTicketAppExtend(TicketAppExtend adTicketAppExtend) {
        this.adTicketAppExtend = adTicketAppExtend;
    }

    public List<TicketPositionScene> getPositionScenes() {
        return positionScenes;
    }

    public void setPositionScenes(List<TicketPositionScene> positionScenes) {
        this.positionScenes = positionScenes;
    }

    public List<TicketAssets> getAvailableAssets() {
        return availableAssets;
    }

    public void setAvailableAssets(List<TicketAssets> availableAssets) {
        this.availableAssets = availableAssets;
    }

    public Short getAssetsDistribute() {
        return assetsDistribute;
    }

    public void setAssetsDistribute(Short assetsDistribute) {
        this.assetsDistribute = assetsDistribute;
    }

    public String getBestAssetsId() {
        return bestAssetsId;
    }

    public Long getUserBxmCount() {
        return userBxmCount;
    }

    public void setUserBxmCount(Long userBxmCount) {
        this.userBxmCount = userBxmCount;
    }

    public Integer getExploreType() {
        return exploreType;
    }

    public void setExploreType(Integer exploreType) {
        this.exploreType = exploreType;
    }

    public void setBestAssetsId(String bestAssetsId) {
        this.bestAssetsId = bestAssetsId;
    }

    public Date getTimesEnlargeDate() {
        return timesEnlargeDate;
    }

    public void setTimesEnlargeDate(Date timesEnlargeDate) {
        this.timesEnlargeDate = timesEnlargeDate;
    }

    @Override
    public BigInteger getRightsId() {
        return rightsId;
    }

    public void setRightsId(BigInteger rightsId) {
        this.rightsId = rightsId;
    }

    public List<TicketRights> getTicketRightsList() {
        return ticketRightsList;
    }

    public void setTicketRightsList(List<TicketRights> ticketRightsList) {
        this.ticketRightsList = ticketRightsList;
    }

    public String getKylinGroupId() {
        return kylinGroupId;
    }

    public void setKylinGroupId(String kylinGroupId) {
        this.kylinGroupId = kylinGroupId;
    }

    public Integer getDeepCpaPrice() {
        return deepCpaPrice;
    }

    public void setDeepCpaPrice(Integer deepCpaPrice) {
        this.deepCpaPrice = deepCpaPrice;
    }

    public Integer getDeepExpectActionType() {
        return deepExpectActionType;
    }

    public void setDeepExpectActionType(Integer deepExpectActionType) {
        this.deepExpectActionType = deepExpectActionType;
    }

    public Short getTargetConvType() {
        return targetConvType;
    }

    public void setTargetConvType(Short targetConvType) {
        this.targetConvType = targetConvType;
    }

    public String getRtbAppKey() {
        return rtbAppKey;
    }

    public void setRtbAppKey(String rtbAppKey) {
        this.rtbAppKey = rtbAppKey;
    }

    public TicketRtaExtend getRtaExtend() {
        return rtaExtend;
    }

    public Byte getSettleType() {
        return settleType;
    }

    public void setSettleType(Byte settleType) {
        this.settleType = settleType;
    }

    public void setRtaExtend(TicketRtaExtend rtaExtend) {
        this.rtaExtend = rtaExtend;
    }

    public String getTicketGroupId() {
        return ticketGroupId;
    }

    public void setTicketGroupId(String ticketGroupId) {
        this.ticketGroupId = ticketGroupId;
    }

    public Integer getExpectActionType() {
        return expectActionType;
    }

    public void setExpectActionType(Integer expectActionType) {
        this.expectActionType = expectActionType;
    }

    public Byte getDeduplicateValidClick() {
        return deduplicateValidClick;
    }

    public void setDeduplicateValidClick(Byte deduplicateValidClick) {
        this.deduplicateValidClick = deduplicateValidClick;
    }

    public Short getAlgoTarget() {
        return algoTarget;
    }

    public void setAlgoTarget(Short algoTarget) {
        this.algoTarget = algoTarget;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
