/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.model.so.rules;

import com.alibaba.fastjson.annotation.JSONField;
import com.bxm.adsprod.model.so.rules.AbstractTwoRule;
import com.google.common.collect.Lists;
import java.time.LocalTime;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class TicketTimeSlotMinuteRuleSo
extends AbstractTwoRule {
    @JSONField(deserialize=false, serialize=false)
    private final List<Entry> entries = Lists.newArrayList();

    @Override
    protected void addItem(String one, String two) {
        this.entries.add(new Entry(one, two));
    }

    @Override
    protected boolean isFirstInt() {
        return false;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    @Override
    protected void addItem(int one, String two) {
    }

    public boolean isNotInTimeSlotMinute() {
        LocalTime now = LocalTime.now();
        for (Entry entry : this.entries) {
            LocalTime startTime = entry.getStartTime();
            LocalTime endTime = entry.getEndTime();
            boolean inTime = now.isAfter(startTime) && now.isBefore(endTime);
            if (!inTime) continue;
            return false;
        }
        return true;
    }

    public static class Entry {
        private LocalTime startTime;
        private LocalTime endTime;

        public Entry(String startTime, String endTime) {
            if (StringUtils.isNotBlank((String)startTime)) {
                this.startTime = LocalTime.parse(startTime);
            }
            if (StringUtils.isNotBlank((String)endTime)) {
                this.endTime = LocalTime.parse(endTime);
            }
        }

        public LocalTime getStartTime() {
            return this.startTime;
        }

        public LocalTime getEndTime() {
            return this.endTime;
        }

        public void setStartTime(LocalTime startTime) {
            this.startTime = startTime;
        }

        public void setEndTime(LocalTime endTime) {
            this.endTime = endTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LocalTime this$startTime = this.getStartTime();
            LocalTime other$startTime = other.getStartTime();
            if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
                return false;
            }
            LocalTime this$endTime = this.getEndTime();
            LocalTime other$endTime = other.getEndTime();
            return !(this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Entry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LocalTime $startTime = this.getStartTime();
            result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
            LocalTime $endTime = this.getEndTime();
            result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
            return result;
        }

        public String toString() {
            return "TicketTimeSlotMinuteRuleSo.Entry(startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
        }
    }
}

