package com.bxm.adsprod.facade.media;

/**
 * ADX广告位渠道
 * Created by zhengwangeng on 2019/8/6.
 */
public enum PositionAdxChannelEnum {

    SOGOU((short) 1, "sogou"),

    XINYI_HULIAN((short) 2, "新义互联"),

    LBA((short) 3, "LBA"),

    HUZHONG((short) 4, "互众"),

    MEITUAN((short) 5, "美团"),

    BXM_SSP((short) 6, "变现猫ssp"),

    MO_JI((short) 7, "墨迹天气"),

    XIAO_DU((short) 8, "小度/百度视频")
    ;

    private Short code;

    private String name;

    PositionAdxChannelEnum(Short code, String name) {
        this.code = code;
        this.name = name;
    }
    public Short getCode() {
        return code;
    }

    public void setCode(Short code) {
        this.code = code;
    }


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static PositionAdxChannelEnum getByCode(Short type) {
        if (null == type) {
            return null;
        }
        for (PositionAdxChannelEnum PositionAdxChannelEnum : PositionAdxChannelEnum.values()) {
            if (PositionAdxChannelEnum.getCode().equals(type)) {
                return PositionAdxChannelEnum;
            }
        }
        return null;
    }

}
