package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;
import java.util.Optional;

/**
 * AB测试落地页配置<br/>
 *
 * @author kerry.jiang
 * @date 2021/3/11 16:22
 */
public class TicketLand implements Serializable {

    private static final long serialVersionUID = 4368329874159718574L;

    public static final short ENABLE_KYLIN = 1;

    /**
     * 待审核
     */
    public static final short AUDIT_STATUS_NOT = 0;
    /**
     * 已审核
     */
    public static final short AUDIT_STATUS_ALREADY = 1;
    /**
     * 审核拒绝
     */
    public static final short AUDIT_STATUS_REFUSE = 2;

    /**
     * 落地页ID
     */
    private Long landId;
    /**
     * 流量占比,最多两位小数
     */
    private Double flowRatio;
    /**
     * 落地页
     */
    private String url;

    /**
     * 是否开启麒麟。0、不开启，1、开启
     */
    private Short enableKylin;

    /**
     * 落地页审核状态
     */
    private Short auditStatus;

    /**
     * 是否开启麒麟替换功能，当没有配置的时候默认是开启。
     * @return 是否开启
     */
    public boolean isEnableKylin() {
        return Optional.ofNullable(getEnableKylin()).orElse(ENABLE_KYLIN) == ENABLE_KYLIN;
    }

    public Long getLandId() {
        return landId;
    }

    public void setLandId(Long landId) {
        this.landId = landId;
    }

    public Double getFlowRatio() {
        return flowRatio;
    }

    public void setFlowRatio(Double flowRatio) {
        this.flowRatio = flowRatio;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Short getEnableKylin() {
        return enableKylin;
    }

    public void setEnableKylin(Short enableKylin) {
        this.enableKylin = enableKylin;
    }

    public Short getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Short auditStatus) {
        this.auditStatus = auditStatus;
    }
}
