package com.bxm.adsprod.model.so.rules;

import org.apache.commons.lang.StringUtils;

/**
 * 分隔字符串 4
 *
 * @author 阿导
 * @version 1.0
 * @fileName com.bxm.adsprod.model.so.rules.AbstractFourRule.java
 * @CopyRright (c) 2018-万物皆导
 * @created 2018-04-23 09:08:00
 */
public abstract class AbstractFourRule extends RuleSo{

    /**
     * 添加分组值
     *
     * @param one
     * @param two
     * @param three
     * @param four
     */
    protected abstract void addItem(String one, String two, String three,String four);

    protected char itemsSeparatorChar() {
        return ',';
    }

    protected char itemSeparatorChar() {
        return '-';
    }

    @Override
    public void setRuleValue(String ruleValue) {
        super.setRuleValue(ruleValue);

        String value = super.getRuleValue();

        if (StringUtils.isBlank(value)) {
            return;
        }

        String[] items = StringUtils.split(value, itemsSeparatorChar());
        for (String item : items) {
            String[] entry = StringUtils.split(item, itemSeparatorChar());
            if (null == entry || entry.length != 4) {
                continue;
            }
            addItem(entry[0], entry[1], entry[2],entry[3]);
        }
    }
}
