package com.bxm.adsprod.model.so.rules;

import org.apache.commons.lang.StringUtils;

/**
 * @author allen
 * @since 1.0.0
 */
public abstract class AbstractThreeStringRule extends RuleSo {

    /**
     * 添加分组值
     *
     * @param one
     * @param two
     * @param three
     */
    protected abstract void addItem(String one, String two, String three);

    protected char itemsSeparatorChar() {
        return ',';
    }

    protected char itemSeparatorChar() {
        return '-';
    }

    @Override
    public void setRuleValue(String ruleValue) {
        super.setRuleValue(ruleValue);

        String value = super.getRuleValue();

        if (StringUtils.isBlank(value)) {
            return;
        }

        String[] items = StringUtils.split(value, itemsSeparatorChar());
        for (String item : items) {
            String[] entry = StringUtils.split(item, itemSeparatorChar());
            if (null == entry || entry.length != 3) {
                continue;
            }
            addItem(entry[0], entry[1], entry[2]);
        }
    }
}
