package com.bxm.adsprod.model.so.rules;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Sets;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Set;

/**
 * <p>
 * 广告券广告位黑白名单规则
 * </p>
 * <pre>
 *     {type}-{media},{media},{media}
 *
 *     type=类型。1- 白名单、2- 黑名单
 *     media=广告位ID
 * </pre>
 *
 * @author allen
 * @date 2017-12-06
 */
public class TicketPositionRuleSo extends RuleSo {

    private static final Logger LOGGER = LoggerFactory.getLogger(TicketPositionRuleSo.class);

    public static final String TYPE_WHITELIST = "1";
    public static final String TYPE_BLACKLIST = "2";

    private static final int VALUE_SPLIT_SIZE = 2;

    /**
     * 是否为黑名单
     */
    @JSONField(deserialize = false, serialize = false)
    private boolean blackList;
    /**
     * 广告位
     */
    @JSONField(deserialize = false, serialize = false)
    private Set<String> positions = Sets.newHashSet();


    @Override
    public void setRuleValue(String ruleValue) {
        super.setRuleValue(ruleValue);

        String value = super.getRuleValue();
        if (StringUtils.isBlank(value)) {
            return;
        }
        if (!value.startsWith("1-") && !value.startsWith("2-")) {
            LOGGER.warn("Invalid value format of 'TicketPositionRuleSo', {}.", value);
            return;
        }
        int startIndex = value.indexOf('-');
        String type = StringUtils.substring(value, 0, startIndex);
        String positions = StringUtils.substring(value, startIndex + 1, value.length());

        this.blackList = (StringUtils.equals(TYPE_BLACKLIST, type));
        String[] positionArray = StringUtils.split(positions, ',');
        for (String s : positionArray) {
            this.positions.add(s);
        }
    }

    public boolean isBlackList() {
        return blackList;
    }


    public Set<String> getPositions() {
        return positions;
    }
}
