package com.bxm.adsprod.facade.ticket.rtb;

import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * rtb累加前置回传配置
 */
@Data
@Accessors(chain = true)
public class PreSummaryFeedbackConfig {
    public static final String ACCOUNT_FIELD = "ACCOUNT";
    public static final String EMPTY_FIELD = "-";

    /**
     * 账户累加前置回传数
     */
    private Integer accountMax;

    /**
     * 广告组累加前置回传数
     */
    private List<AdGroupConfig> adGroupConfigs;

    @Data
    @Accessors(chain = true)
    public static class AdGroupConfig {
        private String adGroupId;
        private Integer max;

        public AdGroupConfig copy() {
            AdGroupConfig adGroupConfig = new AdGroupConfig();
            adGroupConfig.setAdGroupId(adGroupId);
            adGroupConfig.setMax(max);
            return adGroupConfig;
        }
    }

}