package com.bxm.adsprod.integration.abtest;

import com.bxm.abtest.facade.enums.AlgorithmNameEnum;
import com.bxm.abtest.facade.model.AlgorithmRequest;
import com.bxm.abtest.facade.model.AlgorithmResponse;
import com.bxm.abtest.facade.service.ABtestFacadeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/**
 * @author lala
 * @date 2020/10/09
 * @since 1.0.0
 */
@EnableFeignClients("com.bxm.abtest.facade")
@Configuration
public class AbtestServiceIntegration {

    private static final Logger logger = LoggerFactory.getLogger(AbtestServiceIntegration.class);

    @Autowired
    private ABtestFacadeService aBtestFacadeService;

    /**
     * 获取算法code
     *
     * @param algorithmRequest
     * @return
     */
    public String getAlgorithmCode(AlgorithmRequest algorithmRequest) {
        try {
            AlgorithmResponse algorithmResponse = aBtestFacadeService.getAlgorithmCode(algorithmRequest);
            if (algorithmResponse != null && !StringUtils.isEmpty(algorithmResponse.getAlgorithmCode())) {
                return algorithmResponse.getAlgorithmCode();
            } else {
                logger.error(" 返回AlgorithmCode为空的时候默认fm算法");
                return AlgorithmNameEnum.ALGORITHM_TICKET_THREE.getAlgorithmCode();
            }

        } catch (Exception e) {
            logger.error(" 调用abtest失败默认fm算法 {}", e);
            return AlgorithmNameEnum.ALGORITHM_TICKET_THREE.getAlgorithmCode();
        }
    }


}
