package com.bxm.adsprod.integration.activity;

import com.bxm.activites.facade.model.ActivityRedirectDto;
import com.bxm.activites.facade.model.ActivityRequest;
import com.bxm.activites.facade.model.InfoActivity;
import com.bxm.activites.facade.service.ActivityBaseService;
import com.bxm.activites.facade.service.ActivityService;
import com.bxm.activites.facade.service.inspire.InspireActivityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Configuration;

/**
 * 调用活动服务实现
 *
 * @ClassName ActivitiesServiceImpl
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/7/24 18:55
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/7/24 18:55
 **/
@Configuration
@EnableFeignClients("com.bxm.activites.facade")
public class ActivitiesServiceImpl implements ActivitiesService {

    @Autowired(required = false)
    private ActivityBaseService activityBaseService;

    @Autowired(required = false)
    private ActivityService activityService;

    @Autowired(required = false)
    private InspireActivityService inspireActivityService;

    @Override
    public int findUserJoinTimes(String uid, String positionId, String activityId) {
        ActivityRequest activityRequest = new ActivityRequest();
        activityRequest.setUid(uid);
        activityRequest.setPosition(positionId);
        activityRequest.setActivityid(activityId);
        return activityBaseService.getTime(activityRequest);
    }

    @Override
    public boolean subAwardAmount(Long acticityId, Long  awardId){
        return activityService.subAwardAmount(acticityId, awardId);
    }

    @Override
    public InfoActivity getActMsg(String acticityId) {
        return activityService.getActMsg(acticityId);
    }

    @Override
    public InfoActivity getInspire(String appkey, String appEntrance, String ipAddress) {
        ActivityRedirectDto activityInfo = new ActivityRedirectDto();
        activityInfo.setAppKey(appkey);
        activityInfo.setAppEntrance(appEntrance);
        activityInfo.setIpAddress(ipAddress);
        return inspireActivityService.get(activityInfo);
    }
}
