package com.bxm.adsprod.integration.adsmanager;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.bxm.warcar.utils.response.ResultModel;

/**
 * <h3>供adsprod调用更新广告券状态</h3>
 * @author hcmony
 * @since V1.0.0, 2017/12/14 19:11
 */
@FeignClient(name = "adsmanager")
public interface AdsmanagerIntegration {

    @RequestMapping(value = "/adsmanager/updateAdTicket", method = RequestMethod.POST,consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResultModel update(@RequestParam(required = true, name = "id" ) Long id,
                              @RequestParam(required = true, name = "reason") Integer reason,
                              @RequestParam(required = true,name = "status") Short status);


    @RequestMapping(value = "/adsmanager/updateTicketCouponsCode", method = RequestMethod.POST,consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResultModel updateTicketCouponsCode(@RequestParam(required = true, name = "ticketId") Long ticketId,
            @RequestParam(required = true, name = "status") Short status,
            @RequestParam(name = "firstShowTime") Long firstShowTime,
            @RequestParam(name = "useTime") Long useTime,
            @RequestParam(required = true, name = "usePositionId") String usePositionId,
            @RequestParam(required = true, name = "bindDeviceNo") String bindDeviceNo,
            @RequestParam(required = true, name = "couponsCode") String couponsCode);

}
