package com.bxm.adsprod.integration.adsmanager;

import java.math.BigInteger;

/**
 * <h3></h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/15
 */
public interface AdsmanagerService {

    /**
     * 更新广告券状态
     *
     * @param ticketId
     * @param status
     * @param reason
     * @return
     */
    boolean updateAdTicket(BigInteger ticketId, byte status, int reason);

    /**
     * 新增广告券消耗记录
     *
     * @param ticketId
     * @param costRds
     * @param cost
     */
    boolean addTicketCostLog(BigInteger ticketId, double costRds, double cost,String positionId,Long ticketCostId);

    /**
     * Description: 站内户权重计划完成
     * JDK version used:<JDK1.8>
     * Create Date：2018/12/19 11:10
     *
     * @param stationUserWeightIds 权重id集合
     * @return java.lang.Boolean
     * @author hxpeng
     */
    Boolean stationUserWeightComplete(Long stationUserWeightIds);

    /**
     * 更新优惠券码信息
     */
    Boolean updateTicketCouponsCode(BigInteger ticketId, Short status, Long firstShowTime, Long useTime, String usePositionId,
        String bindDeviceNo, String couponsCode);
}
