package com.bxm.adsprod.integration.adsmanager;

import java.math.BigInteger;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.PathUtils;
import com.bxm.warcar.utils.response.ResultModel;
import com.google.common.collect.Maps;

/**
 *
 * @author allen
 * @since V1.0.0 2017/12/15
 */
@Deprecated
//@EnableFeignClients("com.bxm.adsprod.integration.adsmanager")
//@Configuration
//@EnableConfigurationProperties(AdsmanagerConfiguration.class)
public class AdsmanagerServiceHttpImpl implements AdsmanagerService {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdsmanagerServiceHttpImpl.class);

    //@Autowired
    private AdsmanagerConfiguration configuration;
    //@Autowired
    private AdsmanagerIntegration adsmanagerIntegration;

    @Override
    public boolean updateAdTicket(BigInteger ticketId, byte status, int reason) {

        ResultModel resultModel = adsmanagerIntegration.update(ticketId.longValue(),reason,(short) status);
        return resultModel.isSuccessed();
}

    @Override
    public boolean addTicketCostLog(BigInteger ticketId, double costRds, double cost,String positionId,Long ticketCostId) {
        RestTemplate restTemplate = new RestTemplateBuilder().setConnectTimeout(6000).build();
        Map<String, Object> uriVariables = Maps.newHashMap();
        uriVariables.put("ticketId", ticketId);
        uriVariables.put("costRds", costRds);
        uriVariables.put("cost", cost);
        String url = PathUtils.appendToHost(configuration.getHost(), "adsmanager",
                "addTicketCostLog?ticketId={ticketId}&costRds={costRds}&cost={cost}");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Access url: {}, parameters: {}", url, uriVariables);
        }
        HttpEntity<?> entity = HttpEntity.EMPTY;
        ResponseEntity<String> responseEntity = restTemplate.postForEntity(url, entity, String.class, uriVariables);
        RestfulResponse restfulResponse = JsonHelper.convert(responseEntity.getBody(), RestfulResponse.class);
        return restfulResponse.isSuccessed();
    }

    @Override
    public Boolean stationUserWeightComplete(Long stationUserWeightId) {
        RestTemplate restTemplate = new RestTemplateBuilder().setConnectTimeout(6000).build();
        Map<String, Object> uriVariables = Maps.newHashMap();
        uriVariables.put("stationUserWeightId", stationUserWeightId);
        String url = PathUtils.appendToHost(configuration.getHost(), "stationUserWeight",
                "complete?stationUserWeightId={stationUserWeightId}");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Access url: {}, parameters: {}", url, uriVariables);
        }
        HttpEntity<?> entity = HttpEntity.EMPTY;
        ResponseEntity<String> responseEntity = restTemplate.postForEntity(url, entity, String.class, uriVariables);
        RestfulResponse restfulResponse = JsonHelper.convert(responseEntity.getBody(), RestfulResponse.class);
        return restfulResponse.isSuccessed();
    }

    @Override
    public Boolean updateTicketCouponsCode(BigInteger ticketId, Short status, Long firstShowTime, Long useTime, String usePositionId, String bindDeviceNo, String couponsCode) {

        ResultModel resultModel = adsmanagerIntegration.updateTicketCouponsCode(ticketId.longValue(), status, firstShowTime,
                useTime, usePositionId, bindDeviceNo, couponsCode);
        return resultModel.isSuccessed();
    }
}
