package com.bxm.adsprod.integration.adsmanager;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.facade.model.ticket.AdTicketCostLog;
import com.bxm.adsmanager.facade.service.AdsprodTicketFacadeService;
import com.bxm.adsmanager.facade.service.StationUserWeightFacadeService;
import com.bxm.warcar.utils.response.ResultModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Configuration;

import java.math.BigInteger;
import java.util.Date;

/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2019/04/10 09:53
 */
@EnableFeignClients({"com.bxm.adsmanager.facade", "com.bxm.adsmanager.facade.service"})
@Configuration
public class AdsmanagerServiceImpl implements AdsmanagerService {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdsmanagerServiceImpl.class);

    @Autowired
    private AdsprodTicketFacadeService adsprodTicketFacadeService;
    @Autowired
    private StationUserWeightFacadeService stationUserWeightFacadeService;

    @Override
    public boolean updateAdTicket(BigInteger ticketId, byte status, int reason) {
        ResultModel resultModel = adsprodTicketFacadeService.update(ticketId.longValue(),reason,(short) status);
        return resultModel.isSuccessed();
    }

    @Override
    public boolean addTicketCostLog(BigInteger ticketId, double costRds, double cost ,String positionId,Long ticketCostId) {
        AdTicketCostLog adTicketCostLog = new AdTicketCostLog();
        adTicketCostLog.setTicketId(ticketId.longValue());
        adTicketCostLog.setCostRds(costRds);
        adTicketCostLog.setCost(cost);
        adTicketCostLog.setPositionId(positionId);
        //不是本表的主键id，是过滤用
        adTicketCostLog.setId(ticketCostId);
        ResultModel resultModel = adsprodTicketFacadeService.addTicketCostLog(adTicketCostLog);

        if (!resultModel.isSuccessed()) {
            LOGGER.warn("addTicketCostLog failed ,ticketId is {}, resultModel is {}",ticketId, JSON.toJSONString(resultModel));
        }
        return resultModel.isSuccessed();
    }

    @Override
    public Boolean stationUserWeightComplete(Long stationUserWeightId) {
        ResultModel resultModel = stationUserWeightFacadeService.complete(stationUserWeightId);
        return resultModel.isSuccessed();
    }

    @Override
    public Boolean updateTicketCouponsCode(BigInteger ticketId, Short status, Long firstShowTime, Long useTime, String usePositionId,
            String bindDeviceNo, String couponsCode) {
        ResultModel resultModel = adsprodTicketFacadeService.updateTicketCouponsCode(ticketId.longValue(), status, firstShowTime,
                useTime, usePositionId, bindDeviceNo, couponsCode);
        return resultModel.isSuccessed();
    }
}
