package com.bxm.adsprod.integration.adsmedia;

import com.bxm.adsmedia.facade.service.ProviderFacadeService;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Configuration;

/**
 * 开发者信息<br/>
 *
 * @author kerry.jiang
 * @date 2019/10/17 11:14
 */
@Configuration
@EnableFeignClients("com.bxm.adsmedia.facade")
public class AdsmediaFacadeServiceImpl implements AdsmediaFacadeService {

    @Autowired(required = false)
    private ProviderFacadeService providerFacadeService;

    @Override
    public String getAppSecretByAppKey(String appKey) {
        ResultModel<String> resultModel = providerFacadeService.getAppSecretByAppKey(appKey);
        return resultModel.getReturnValue();
    }
}
