package com.bxm.adsprod.integration.dnn;

import com.alibaba.fastjson.JSON;
import com.bxm.adsalgorithm.facade.enums.ModelKeyEnum;
import com.bxm.adsalgorithm.facade.model.DNNFeatureDto;
import com.bxm.adsalgorithm.facade.model.DNNTicketCTRRO;
import com.bxm.adsalgorithm.facade.service.DNNFacadeService;
import com.bxm.adsfm.facade.model.FeatureDto;
import com.bxm.adsfm.facade.model.TicketCTRRO;
import com.bxm.adsfm.facade.service.FMFacadeService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Configuration;

import java.math.BigInteger;
import java.util.*;

/**
 * @author lala
 * @date 2020/10/09
 * @since 1.0.0
 */
@EnableFeignClients("com.bxm.adsalgorithm.facade.service")
@Configuration
public class DNNTicketServiceIntegration {

    private static final Logger logger = LoggerFactory.getLogger(DNNTicketServiceIntegration.class);

    @Autowired
    private DNNFacadeService dnnFacadeService;


    /**
     * 批量获取ctr
     *
     * @param featureDtos
     * @return
     */
    public List<TicketCTRRO> getListTicketCtr(List<FeatureDto> featureDtos,String modelId) {
        try {
            List<DNNFeatureDto> dnnFeatureDtos =covert(featureDtos);

            List<DNNTicketCTRRO> dnnctrByList = dnnFacadeService.getCTRByParams(dnnFeatureDtos,modelId);
            if (CollectionUtils.isEmpty(dnnctrByList)) {
                return new ArrayList();
            }
            return getTicketCTRROS(dnnctrByList);

        } catch (Exception e) {
            logger.error("调用算法获取失败  ", e);
            return new ArrayList<>();
        }
    }

    private List<DNNFeatureDto> covert(List<FeatureDto> featureDtos){
        List<DNNFeatureDto> dnnFeatureDtos =new ArrayList<>();
        for (FeatureDto featureDto : featureDtos) {
            DNNFeatureDto dnnFeatureDto = new DNNFeatureDto();
            BeanUtils.copyProperties(featureDto, dnnFeatureDto);
            dnnFeatureDtos.add(dnnFeatureDto);
        }
        return dnnFeatureDtos;
    }


    private List<TicketCTRRO> getTicketCTRROS(List<DNNTicketCTRRO> dnnctrByList) {
        List<TicketCTRRO> list=new ArrayList<>();
        for (DNNTicketCTRRO dnnTicketCTRRO : dnnctrByList) {
            TicketCTRRO ticketCTRRO = new TicketCTRRO();
            BeanUtils.copyProperties(dnnTicketCTRRO, ticketCTRRO);
            list.add(ticketCTRRO);
        }
        return list;
    }


    public Map<BigInteger,TicketCTRRO> getMapTicketCtr(List<FeatureDto> featureDtos, String modelId) {
        try {
            List<DNNFeatureDto> dnnFeatureDtos =covert(featureDtos);

            List<DNNTicketCTRRO> dnnctrByList = new ArrayList<>(featureDtos.size());
            if(StringUtils.equalsIgnoreCase(modelId, ModelKeyEnum.CVR_MODEL_006.getIndex())){
                dnnctrByList = dnnFacadeService.getCTRByParams(dnnFeatureDtos,modelId);
            }else{
                //加素材特征的接口
                dnnctrByList = dnnFacadeService.getCtrcvr(dnnFeatureDtos, modelId);
            }

            if (CollectionUtils.isEmpty(dnnctrByList)) {
                return new HashMap<>();
            }
            Map<BigInteger,TicketCTRRO> map =new HashMap<>();
            for (DNNTicketCTRRO dnnTicketCTRRO : dnnctrByList) {
                TicketCTRRO ticketCTRRO = new TicketCTRRO();
                BeanUtils.copyProperties(dnnTicketCTRRO, ticketCTRRO);
                map.put(new BigInteger(ticketCTRRO.getTicketId().toString()),ticketCTRRO);
            }
            return map;

        } catch (Exception e) {
            logger.error("调用算法获取失败  ", e);
            return new HashMap<>();
        }
    }

    public List<TicketCTRRO> getTicketCtrByModelId(List<FeatureDto> featureDtos,String modelId) {
        try {
            List<DNNFeatureDto> dnnFeatureDtos =covert(featureDtos);
            List<DNNTicketCTRRO> dnnctrByList = new ArrayList<>(featureDtos.size());

            if(StringUtils.equalsIgnoreCase(modelId, ModelKeyEnum.CVR_MODEL_006.getIndex())){
                dnnctrByList = dnnFacadeService.getCTRByParams(dnnFeatureDtos,modelId);
            }else{
                //加素材特征的接口
                dnnctrByList = dnnFacadeService.getCtrcvr(dnnFeatureDtos, modelId);
            }

            if (CollectionUtils.isEmpty(dnnctrByList)) {
                return new ArrayList();
            }
            return getTicketCTRROS(dnnctrByList);

        } catch (Exception e) {
            logger.error("调用算法获取失败  ", e);
            return new ArrayList<>();
        }
    }


    public Map<String,List<TicketCTRRO>>  getTicketAssetsCtrList(List<FeatureDto> featureDtos, String modelId) {
        try {
            List<DNNFeatureDto> dnnFeatureDtos =covert(featureDtos);

            List<DNNTicketCTRRO> dnnctrByList = dnnFacadeService.getCtrcvr(dnnFeatureDtos, modelId);
            if (CollectionUtils.isEmpty(dnnctrByList)) {
                return new HashMap<>();
            }
            Map<String,List<TicketCTRRO>> map =new HashMap<>();
            for (DNNTicketCTRRO dnnTicketCTRRO : dnnctrByList) {
                TicketCTRRO ticketCTRRO = new TicketCTRRO();
                BeanUtils.copyProperties(dnnTicketCTRRO, ticketCTRRO);
                List<TicketCTRRO> list =map.getOrDefault(dnnTicketCTRRO.getTicketId().toString(),new ArrayList<>());
                list.add(ticketCTRRO);
                map.put(dnnTicketCTRRO.getTicketId().toString(),list);
            }
            return map;

        } catch (Exception e) {
            logger.error("调用素材算法获取失败  ", e);
            return new HashMap<>();
        }
    }

}
