package com.bxm.adsprod.integration.fm;

import com.bxm.adsfm.facade.model.FeatureDto;
import com.bxm.adsfm.facade.model.TicketCTRRO;
import com.bxm.adsfm.facade.service.FMFacadeService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/**
 * @author allen
 * @date 2019/4/11
 * @since 1.0.0
 */
@EnableFeignClients("com.bxm.adsfm.facade.service")
@Configuration
public class FmTicketServiceIntegration {

    private static final Logger logger = LoggerFactory.getLogger(FmTicketServiceIntegration.class);

    @Autowired
    private FMFacadeService fmFacadeService;

    /**
     * 单个获取
     *
     * @param featureDto
     * @return
     */
    public TicketCTRRO getTicketCtr(FeatureDto featureDto) {
        try {
            return fmFacadeService.getFMByUid(featureDto);
        } catch (Exception e) {
            logger.error(" ", e);
            return getDefaultCtr(featureDto);
        }
    }


    /**
     * 批量获取ctr
     *
     * @param featureDtos
     * @return
     */
    public List<TicketCTRRO> getListTicketCtr(List<FeatureDto> featureDtos) {
        try {
            List<TicketCTRRO> fmctrByList = fmFacadeService.getFMCTRByList(featureDtos);
            //结果有可能为空
            return CollectionUtils.isEmpty(fmctrByList) ? new ArrayList<>() : fmctrByList;
        } catch (Exception e) {
            logger.error(" 调用fm算法获取ctr失败  ", e);
            return new ArrayList<>();
        }
    }

    private List<TicketCTRRO> getListDefaultCtr(List<FeatureDto> featureDtos) {
        List<TicketCTRRO> defaultList = new LinkedList<>();
        for (FeatureDto featureDto : featureDtos) {
            defaultList.add(getDefaultCtr(featureDto));
        }
        return defaultList;
    }

    public TicketCTRRO getDefaultCtr(FeatureDto featureDto) {
        TicketCTRRO ctrro = new TicketCTRRO();
        ctrro.setCtr(0D);
        ctrro.setTicketId(Long.valueOf(featureDto.getPreId()));
        return ctrro;
    }

}
