package com.bxm.adsprod.integration.user;

import com.bxm.user.facade.DevRequest;
import com.bxm.user.facade.SdkInitCache;
import com.bxm.user.facade.UserProfile;
import com.bxm.user.facade.service.UserService;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;
import java.util.List;

/**
 * 用户信息<br/>
 *
 * @author kerry.jiang
 * @date 2020/9/23 10:55
 */
@Configuration
@EnableFeignClients("com.bxm.user.facade.service")
public class UserServiceIntegration {

    @Resource
    private UserService userService;

    /**
     * 获取uid<br/>
     *
     * @param request
     * @return java.lang.String
     */
    public String getUid(DevRequest request) {
        UserProfile user = userService.getUser(request);
        if(null == user){
            return null;
        }
        return user.getUid();
    }

    /**
     * 获取SDK初始化信息<br/>
     *
     * @param request
     * @return java.lang.String
     */
    public SdkInitCache getSdkInit(DevRequest request) {
        return userService.getSdkInit(request);
    }

    /**
     * 获取SDK初始化信息<br/>
     *
     * @param uid @see {@link UserServiceIntegration#getUid(DevRequest)}
     * @return java.lang.String
     */
    public SdkInitCache getSdkInitByUid(String uid) {
        return userService.getSdkInitByUid(uid);
    }

    /**
     * 获取SDK初始化时的已安装APP包名列表<br/>
     *
     * @param request
     * @return java.lang.String
     */
    public List<String> getInstalledList(DevRequest request) {
        return userService.getInstalledList(request);
    }

    /**
     * 获取SDK初始化时的已安装APP包名列表<br/>
     *
     * @param uid @see {@link UserServiceIntegration#getUid(DevRequest)}
     * @return java.lang.String
     */
    public List<String> getInstalledListByUid(String uid) {
        return userService.getInstalledListByUid(uid);
    }

    /**
     * 获取用户的个推标签<br/>
     *
     * @param uid @see {@link UserServiceIntegration#getUid(DevRequest)}
     * @return java.lang.String
     */
    public List<String> getTagsForGetuiByUid(String uid) {
        return userService.getTagsForGetuiByUid(uid);
    }
}
