package com.bxm.adsprod.service.advertiser;

import com.alibaba.dubbo.config.annotation.Service;
import com.bxm.adsprod.common.eventbus.EventPark;
import com.bxm.adsprod.facade.advertiser.AdvertiserService;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.service.ticket.event.BalanceChangedEvent;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.google.common.base.Preconditions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.math.BigInteger;

/**
 * 在第一次使用需要初始化广告主的余额。并在后续每次加款中调用方法{@link #incrementBalance(BigInteger, Long)}来确保余额的一致性。
 * @author allen
 * @since V1.0.0 2017/12/14
 */
@Service(version = "1.0.0", owner = "allen")
public class AdvertiserServiceImpl implements AdvertiserService {

    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier("jedisCounter")
    private Counter counter;
    @Autowired
    private EventPark eventPark;

    @Override
    public Long getAdvertiserBalance(BigInteger advertiserId) {
        return fetcher.hfetch(getKeyGenerator(), String.valueOf(advertiserId), null, Long.class);
    }

    @Override
    public Long incrementBalance(BigInteger advertiserId, Long incValue) {
        Preconditions.checkNotNull(advertiserId);
        Preconditions.checkNotNull(incValue);
        KeyGenerator keyGenerator = getKeyGenerator();
        Long rst = counter.hincrementByAndGet(keyGenerator, String.valueOf(advertiserId), incValue);
        eventPark.post(new BalanceChangedEvent(this, advertiserId, incValue, rst));
        return rst;
    }

    private KeyGenerator getKeyGenerator() {
        return TicketKeyGenerator.Advertiser.getBalance();
    }
}
