package com.bxm.adsprod.service.commons.cached;

import com.bxm.adsprod.common.message.MessageBody;
import com.bxm.adsprod.common.utils.NamedThreadFactory;
import com.bxm.adsprod.service.commons.cached.annotation.Caching;
import com.bxm.adsprod.service.commons.configure.AdsProdConfiguration;
import com.bxm.adsprod.service.commons.message.annotation.Messaging;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.SendResult;
import com.bxm.warcar.utils.JsonHelper;
import org.apache.commons.beanutils.BeanUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

import javax.annotation.PreDestroy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * 方法结果缓存
 * @author allen
 * @since 1.0.0
 */
@Aspect
@Component
public class CachedAspect {

    private static final Logger LOGGER = LoggerFactory.getLogger(CachedAspect.class);

    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;

    @AfterReturning(pointcut = "@annotation(com.bxm.adsprod.service.commons.cached.annotation.Caching)", returning = "returning")
    public void doAfterReturning(JoinPoint point, Object returning) {
        Object[] args = point.getArgs();

        Method method = getMethod(point);
        if (null == method) {
            return;
        }
        if (null == returning) {
            return;
        }

        final Caching annotation = method.getAnnotation(Caching.class);

        if (null == annotation) {
            return;
        }

        try {

            String field = BeanUtils.getProperty(returning, annotation.keyFieldName());

            updater.update(new KeyGenerator() {
                @Override
                public String generateKey() {
                    return annotation.prefix() + field;
                }
            }, returning, annotation.expireTimesInSecond());
        } catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("getMappedProperty: ", e);
            }
        }
    }

    private Method getMethod(JoinPoint point) {
        MethodSignature methodSignature = (MethodSignature) point.getSignature();

        Class<?> targetClass = point.getTarget().getClass();
        try {
            return targetClass.getMethod(methodSignature.getName(), methodSignature.getParameterTypes());
        } catch (NoSuchMethodException e) {
            return null;
        }
    }
}
