package com.bxm.adsprod.service.commons.cached;

import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.autoconfigure.jedis.JedisConfiguration;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

/**
 * @author allen
 * @since 1.0.0
 */
@Configuration
@EnableConfigurationProperties(JedisConfiguration.class)
public class JedisAutoConfiguration {

    @Autowired
    private JedisConfiguration configuration;

    @Bean
    public JedisPool jedis1Pool() {
        return new JedisPool(configuration, configuration.getHost(), configuration.getPort(),
                configuration.getTimeout(), configuration.getPassword(), 1);
    }

    @Bean
    public Fetcher jedis1Fetcher() {
        return new JedisFetcher(jedis1Pool());
    }

    @Bean
    public Updater jedis1Updater() {
        return new JedisUpdater(jedis1Pool());
    }
}
