package com.bxm.adsprod.service.commons.cached.annotation;

import java.lang.annotation.*;

/**
 * 声明这个方法返回的结果需要缓存
 *
 * @author allen
 * @since 1.0.0
 */
@Documented
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Inherited
public @interface Caching {

    /**
     * @return 缓存的 key 前缀
     */
    String prefix();

    /**
     * @return 缓存的 key 后缀值对应的对象Field名。
     */
    String keyFieldName();

    /**
     * @return 过期时间，单位：秒
     */
    int expireTimesInSecond() default 5 * 60;
}
