package com.bxm.adsprod.service.commons.message.annotation;

import com.bxm.adsprod.service.commons.configure.TopicConfiguration;
import org.springframework.core.annotation.AliasFor;

import java.lang.annotation.*;

/**
 * <h3>声明方法支持消息队列传递</h3>
 * <p></p>
 *
 * @author allen
 * @since V1.0.0 2017/12/08
 */
@Documented
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Inherited
public @interface Messaging {

    @AliasFor("topic")
    String value() default "";

    /**
     * @return 主题字段名
     * @see TopicConfiguration
     */
    String topicFieldNameOfConfiguration() default "";

    /**
     * 过滤标签
     * @return
     */
    String tags() default "";

    /**
     * 消息标志，系统不做干预，完全由应用决定如何使用
     * @return
     */
    int flag() default 0;

    /**
     * 消息延迟级别，默认不延迟
     *
     * @see com.bxm.warcar.mq.DelayTimeLevel
     * @return
     */
    int delayTimeLevel() default 0;
}
