package com.bxm.adsprod.service.commons.metrics;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

/**
 * <h3>消耗时间切面</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/26
 */
@Order(-99)
@Aspect
@Component
public class MetricsAspect {

    @Autowired
    private ConsumeTimeMetrics consumeTimeMetrics;
    @Autowired
    private CounterMetrics counterMetrics;

    @Bean
    public ConsumeTimeMetrics consumeTimeMetrics() {
        return new ConsumeTimeMetrics();
    }

    @Bean
    public CounterMetrics counterMetrics() {
        return new CounterMetrics();
    }

    @Around(value = "within(@com.alibaba.dubbo.config.annotation.Service *)")
    public Object around(ProceedingJoinPoint point) throws Throwable {

        long start = System.currentTimeMillis();

        Object proceed = point.proceed();

        try {
            String name = getServiceName(point);
            long consumingTime = System.currentTimeMillis() - start;

            consumeTimeMetrics.increaseTask(name, consumingTime);
            counterMetrics.incrementSuccessTask(name);
        }
        catch (Exception e) {
            // Ignore
        }

        return proceed;
    }

    @AfterThrowing(value = "within(@com.alibaba.dubbo.config.annotation.Service *))", throwing = "throwing")
    public void afterThrowing(JoinPoint point, Throwable throwing) {
        counterMetrics.incrementFailTask(getServiceName(point));
    }

    private String getServiceName(JoinPoint point) {
        return point.getSignature().toShortString();
    }
}
