package com.bxm.adsprod.service.commons.pushable;

import com.alibaba.dubbo.config.annotation.Service;
import com.bxm.adsprod.common.pushable.CachePushableBus;
import com.bxm.adsprod.facade.commons.CachePushException;
import com.bxm.adsprod.facade.commons.CachePushableService;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.utils.StringHelper;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

/**
 * @author allen
 * @date 2017-12-04
 */
@Service(version = "1.0.0")
public class CachePushableServiceImpl implements CachePushableService {

    private static final Logger LOGGER = LoggerFactory.getLogger(CachePushableServiceImpl.class);

    @Autowired
    private CachePushableBus bus;

    @Override
    public String push(String serviceName, Map<String, Object> parameters, byte[] data) throws CachePushException {
        if (StringUtils.isBlank(serviceName)) {
            throw new CachePushException("'serviceName' connet be blank");
        }
        Pushable bean = bus.getRefreshable(serviceName);
        if (null == bean) {
            throw new CachePushException("Illegal serviceName: " + serviceName);
        }

        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Starting refresh cache, serviceName={}, parameters={}, data={}",
                    serviceName, parameters, StringHelper.convert(data));
        }

        try {
            submitRefreshTask(parameters, bean, data);

            return "Service [ " + serviceName + "] cached has been refreshed.";
        } catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("push: ", e);
            }
            throw new CachePushException("push: ", e);
        }

    }

    public void submitRefreshTask(@RequestParam Map<String, Object> parameters, Pushable bean, byte[] data) {
        bean.push(parameters, data);
    }
}
