package com.bxm.adsprod.service.media;

import org.apache.commons.lang.StringUtils;

/**
 * <h3>Position id resolver.</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/25
 */
public interface PositionIdResolver {

    /**
     * 分解广告位ID
     * @param positionId
     * @return [appkey, business/appentrance]
     */
    default String[] resolve(String positionId) {
        if (StringUtils.isBlank(positionId)) {
            return null;
        }
        return StringUtils.split(positionId, '-');
    }

    public static final PositionIdResolver DEFAULT = new PositionIdResolver() {
    };
}
