package com.bxm.adsprod.service.media;

import com.bxm.adsprod.facade.media.PositionOfRules;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.Fetcher;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

/**
 * @author allen
 * @since V1.0.0 2017/12/22
 */
@Component
public class PositionServiceImpl implements PositionService {

    private static final Logger LOGGER = LoggerFactory.getLogger(PositionServiceImpl.class);

    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;

    @Override
    public PositionOfRules get(String positionId) {
        if (StringUtils.isBlank(positionId)) {
            return null;
        }

        return fetcher.hfetch(TicketKeyGenerator.Media.getPositions(), positionId, null, PositionOfRules.class);
    }
}
