package com.bxm.adsprod.service.ticket;

import com.alibaba.dubbo.config.annotation.Service;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketStatisticsService;
import com.bxm.warcar.cache.Fetcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.math.BigDecimal;
import java.math.BigInteger;

/**
 * <h3>广告券相关统计服务实现</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/13
 */
@Service(version = "1.0.0", owner = "allen")
public class TicketStatisticsServiceImpl implements TicketStatisticsService {

    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;

    @Override
    public long getBudgetOfToday(BigInteger ticketId) {
        Long rst = fetcher.hfetch(TicketKeyGenerator.Statistics.getBudgetOfDaily(), String.valueOf(ticketId), null, Long.class);
        return null == rst ? 0 : rst;
    }

    @Override
    public long getBudgetOfTimeline(BigInteger ticketId, int startHour, int endHour) {
        if (endHour < startHour) {
            throw new IllegalArgumentException("endHour must be >= startHour. " + endHour + "<" + startHour);
        }
        BigDecimal rst = new BigDecimal(0);
        for (int i = startHour; i <= endHour; i++) {
            Long rstForHour = fetcher.hfetch(TicketKeyGenerator.Statistics.getBudgetOfHourly(i), String.valueOf(ticketId), null, Long.class);
            if (null != rstForHour) {
                rst = rst.add(new BigDecimal(rstForHour));
            }
        }
        return rst.longValue();
    }
}
