package com.bxm.adsprod.service.ticket;

import com.bxm.adsprod.facade.ticket.Ticket;

import java.util.List;

/**
 * <h3>广告券权重服务</h3>
 * <p></p>
 *
 * @author allen
 * @since V1.0.0 2017/12/07
 */
public interface TicketWeightService {

    /**
     * 根据将发放的广告券集合进行权重算法计算后返回下一张需要发放的广告券。
     *
     * @param tickets 可出的广告券
     * @param uid UID
     * @param last 用户最后一次获取的广告券
     * @return
     */
    Ticket getBest(List<Ticket> tickets, String uid, Ticket last);
}
