package com.bxm.adsprod.service.ticket.decorator;

import com.bxm.adsprod.common.interceptor.AbstractInterceptor;
import com.bxm.adsprod.common.interceptor.Invocation;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketAssets;
import com.bxm.warcar.ip.IP;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Iterator;
import java.util.List;

/**
 * <h3>广告券素材拦截器</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/29
 */
@Component
public class TicketAssetsInterceptor extends AbstractInterceptor {

    @Override
    protected void doIntercept(Invocation invocation) {

        DecoratorRequestModel requestModel = (DecoratorRequestModel) invocation.getRequestModel();

        List<Ticket> tickets = requestModel.getTickets();
        if (CollectionUtils.isEmpty(tickets)) {
            return;
        }

        IP iprst = requestModel.getIprst();
        String regioncode = iprst.getRegioncode();
        if (StringUtils.isBlank(regioncode)) {
            return;
        }

        Iterator<Ticket> iterator = tickets.iterator();

        while (iterator.hasNext()) {
            Ticket ticket = iterator.next();

            List<TicketAssets> assets = ticket.getAssets();
            for (TicketAssets asset : assets) {
                if (null == asset.getVars()) {
                    continue;
                }
                if (asset.getVars() == TicketAssets.VARS_PROVINCE) {
                    fillNameForVars(asset, iprst.getProvince());
                } else if (asset.getVars() == TicketAssets.VARS_CITY) {
                    fillNameForVars(asset, iprst.getCity());
                }
            }
        }
    }

    private void fillNameForVars(TicketAssets asset, String varValue) {
        asset.setName(new StringBuilder().append(asset.getName()).append(varValue).append(asset.getContent()).toString());
    }
}
