package com.bxm.adsprod.service.ticket.decorator;

import com.bxm.adsprod.common.interceptor.Interceptor;
import com.bxm.adsprod.common.interceptor.Invocation;
import com.bxm.adsprod.service.ticket.utils.InterceptorChainUtils;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * <h3>广告券拦截器链，可以设置链条顺序</h3>
 * <p></p>
 *
 * @author allen
 * @since V1.0.0 2017/12/07
 */
@Component
public final class TicketDecoratorInterceptorChain implements Interceptor, ApplicationListener<ContextRefreshedEvent> {

    @Autowired
    private TicketAssetsInterceptor ticketAssetsInterceptor;

    private final List<Interceptor> interceptors = Lists.newArrayList();

    private void addInterceptors() {
        interceptors.add(ticketAssetsInterceptor);

        InterceptorChainUtils.setChain(interceptors);
    }

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (null == event.getApplicationContext().getParent()) {
            addInterceptors();
        }
    }

    @Override
    public void intercept(Invocation invocation) {
        interceptors.get(0).intercept(invocation);
    }

}
