package com.bxm.adsprod.service.ticket.event;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.math.BigInteger;
import java.util.EventObject;

/**
 * <h3>广告主余额变更事件，运营加款、扣款动作</h3>
 * <p>
 *     广告主扣款直到余额不足请使用{@link BalanceNotEnoughEvent}
 * </p>
 *
 * @author allen
 * @since V1.0.0 2017/12/27
 */
public class BalanceChangedEvent extends EventObject {

    private final BigInteger advertiser;
    private final long changedValue;
    private final long finalValue;

    public BalanceChangedEvent(Object source, BigInteger advertiser, long changedValue, long finalValue) {
        super(source);
        Preconditions.checkNotNull(advertiser);
        this.advertiser = advertiser;
        this.changedValue = changedValue;
        this.finalValue = finalValue;
    }

    public BigInteger getAdvertiser() {
        return advertiser;
    }

    public long getChangedValue() {
        return changedValue;
    }

    public long getFinalValue() {
        return finalValue;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
