package com.bxm.adsprod.service.ticket.event;

import com.bxm.adsprod.facade.ticket.Ticket;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.util.EventObject;

/**
 * <h3>日预算不足事件</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/15
 */
public class DailyBudgetNotEnoughEvent extends EventObject {

    private final Ticket ticket;

    /**
     * Constructs a prototypical Event.
     *
     * @param source The object on which the Event initially occurred.
     * @throws IllegalArgumentException if source is null.
     */
    public DailyBudgetNotEnoughEvent(Object source, Ticket ticket) {
        super(source);
        this.ticket = ticket;
    }

    public Ticket getTicket() {
        return ticket;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
